/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.units;

import java.util.List;
import org.jaudiolibs.pipes.Buffer;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.units.AudioTable;

public final class Player
extends Pipe {
    private AudioTable table;
    private double in;
    private double out;
    private double speed;
    private boolean playing;
    private boolean looping;
    private double cursor;
    private double realSpeed;
    private int iIn;
    private int iOut;
    private Channel[] channels = new Channel[]{new Channel()};
    private static final int SMOOTH_AMOUNT = 256;

    public Player() {
        super(0, 16);
        this.reset();
    }

    public Player table(AudioTable table) {
        if (table != this.table) {
            this.table = table;
            this.triggerSmoothing();
        }
        return this;
    }

    public AudioTable table() {
        return this.table;
    }

    public Player in(double in) {
        if (in < 0.0) {
            in = 0.0;
        } else if (in > 1.0) {
            in = 1.0;
        }
        this.in = in;
        return this;
    }

    public double in() {
        return this.in;
    }

    public Player out(double out) {
        if (out < 0.0) {
            out = 0.0;
        } else if (out > 1.0) {
            out = 1.0;
        }
        this.out = out;
        return this;
    }

    public double out() {
        return this.out;
    }

    public Player position(double position) {
        if (position < 0.0) {
            position = 0.0;
        } else if (position > 1.0) {
            position = 1.0;
        }
        if (this.table != null) {
            this.cursor = position * (double)this.table.size();
            this.triggerSmoothing();
        }
        return this;
    }

    public double position() {
        return this.table == null ? 0.0 : this.cursor / (double)this.table.size();
    }

    public Player speed(double speed) {
        this.speed = speed;
        return this;
    }

    public double speed() {
        return this.speed;
    }

    public Player playing(boolean playing) {
        if (this.playing != playing) {
            this.triggerSmoothing();
        }
        this.playing = playing;
        return this;
    }

    public boolean playing() {
        return this.playing;
    }

    public Player looping(boolean looping) {
        this.looping = looping;
        return this;
    }

    public boolean looping() {
        return this.looping;
    }

    public Player play() {
        if (this.speed < 0.0) {
            this.position(1.0);
        } else {
            this.position(0.0);
        }
        this.playing = true;
        return this;
    }

    public Player stop() {
        return this.playing(false);
    }

    public void reset() {
        this.table = null;
        this.in = 0.0;
        this.out = 1.0;
        this.speed = 1.0;
        this.looping = false;
    }

    protected void process(List<Buffer> buffers) {
        block13: {
            block11: {
                int loopLength;
                block12: {
                    if (buffers.size() != this.channels.length) {
                        this.configureChannels(buffers.size());
                    }
                    if (this.table != null) {
                        this.iIn = (int)(this.in * (double)this.table.size());
                        this.iOut = (int)(this.out * (double)this.table.size());
                        this.realSpeed = this.table.hasSampleRate() ? this.speed * (this.table.sampleRate() / (double)buffers.get(0).getSampleRate()) : this.speed;
                    } else {
                        this.iOut = 0;
                        this.iIn = 0;
                    }
                    loopLength = this.iOut - this.iIn;
                    if (!this.playing || loopLength <= 0) break block11;
                    for (int i = 0; i < this.channels.length; ++i) {
                        this.channels[i].processPlaying(buffers.get(i), i % this.table.channels(), true);
                    }
                    this.cursor += this.realSpeed * (double)buffers.get(0).getSize();
                    if (!(this.cursor > (double)this.iOut)) break block12;
                    if (this.looping) {
                        while (this.cursor > (double)this.iOut) {
                            this.cursor -= (double)loopLength;
                        }
                    } else {
                        this.cursor = this.iIn;
                        this.playing = false;
                    }
                    break block13;
                }
                if (!(this.cursor < (double)this.iIn)) break block13;
                if (this.looping) {
                    while (this.cursor < (double)this.iIn) {
                        this.cursor += (double)loopLength;
                    }
                } else {
                    this.cursor = this.iOut - 1;
                    this.playing = false;
                }
                break block13;
            }
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].processStopped(buffers.get(i), 0, true);
            }
        }
    }

    protected void skip(int samples) {
        int loopLength = this.iOut - this.iIn;
        if (this.playing && loopLength > 0) {
            this.cursor += this.realSpeed * (double)samples;
            if (this.cursor > (double)this.iOut) {
                if (this.looping) {
                    while (this.cursor > (double)this.iOut) {
                        this.cursor -= (double)loopLength;
                    }
                } else {
                    this.cursor = this.iIn;
                    this.playing = false;
                }
            } else if (this.cursor < (double)this.iIn) {
                if (this.looping) {
                    while (this.cursor < (double)this.iIn) {
                        this.cursor += (double)loopLength;
                    }
                } else {
                    this.cursor = this.iOut - 1;
                    this.playing = false;
                }
            }
        }
    }

    private void configureChannels(int count) {
        Channel[] old = this.channels;
        this.channels = new Channel[count];
        int copy = Math.min(old.length, this.channels.length);
        if (copy > 0) {
            System.arraycopy(old, 0, this.channels, 0, copy);
        }
        for (int i = copy; i < this.channels.length; ++i) {
            this.channels[i] = new Channel();
        }
    }

    private void triggerSmoothing() {
        for (Channel c : this.channels) {
            c.smoothIndex = 256;
        }
    }

    private class Channel {
        private double previousSample = 0.0;
        private int smoothIndex = 0;

        private Channel() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processPlaying(Buffer buffer, int channel, boolean rendering) {
            if (!rendering) {
                this.smoothIndex = 0;
                return;
            }
            int bSize = buffer.getSize();
            float[] data = buffer.getData();
            double p = Player.this.cursor;
            int loopLength = Player.this.iOut - Player.this.iIn;
            if (loopLength <= 0 || Player.this.table == null) {
                if (this.previousSample != 0.0) {
                    this.smoothIndex = 256;
                }
                this.processStopped(buffer, 0, rendering);
                return;
            }
            for (int i = 0; i < bSize; p += Player.this.realSpeed, ++i) {
                if (p >= (double)Player.this.iOut) {
                    this.smoothIndex = 256;
                    if (!Player.this.looping) {
                        this.processStopped(buffer, i, rendering);
                        return;
                    }
                    while (p >= (double)Player.this.iOut) {
                        p -= (double)loopLength;
                    }
                } else if (p < (double)Player.this.iIn) {
                    this.smoothIndex = 256;
                    if (!Player.this.looping) {
                        this.processStopped(buffer, i, rendering);
                        return;
                    }
                    while (p < (double)Player.this.iIn) {
                        p += (double)loopLength;
                    }
                }
                double sample = Player.this.table.get(channel, p);
                if (this.smoothIndex > 0) {
                    sample = this.smooth(sample);
                    --this.smoothIndex;
                }
                data[i] = (float)sample;
                this.previousSample = sample;
            }
        }

        private void processStopped(Buffer buffer, int offset, boolean rendering) {
            int i;
            if (!rendering) {
                this.smoothIndex = 0;
                return;
            }
            int bSize = buffer.getSize();
            float[] data = buffer.getData();
            if (this.smoothIndex > 0) {
                for (i = offset; i < bSize; ++i) {
                    double sample;
                    this.previousSample = sample = this.smooth(0.0);
                    data[i] = (float)sample;
                    --this.smoothIndex;
                    if (sample != 0.0 && this.smoothIndex != 0) continue;
                    this.smoothIndex = 0;
                    offset = i;
                    break;
                }
            }
            for (i = offset; i < bSize; ++i) {
                data[i] = 0.0f;
            }
        }

        private double smooth(double sample) {
            sample -= (sample - this.previousSample) * (double)this.smoothIndex / 256.0;
            return sample;
        }
    }
}

