/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.mojo;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.javacc.mojo.AbstractPreprocessorMojo;
import org.javacc.mojo.GrammarInfo;
import org.javacc.mojo.JTB;

public class JTBMojo
extends AbstractPreprocessorMojo {
    private String packageName;
    private String nodePackageName;
    private String visitorPackageName;
    private Boolean supressErrorChecking;
    private Boolean javadocFriendlyComments;
    private Boolean descriptiveFieldNames;
    private String nodeParentClass;
    private Boolean parentPointers;
    private Boolean specialTokens;
    private Boolean scheme;
    private Boolean printer;
    private File sourceDirectory;
    private File outputDirectory;
    private File timestampDirectory;
    private int staleMillis;
    private String[] includes;
    private String[] excludes;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jtb", "**/*.JTB"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getTimestampDirectory() {
        return this.timestampDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jtbFile = grammarInfo.getGrammarFile();
        File jjDirectory = new File(this.getOutputDirectory(), grammarInfo.getParserDirectory());
        String nodePackage = grammarInfo.resolvePackageName(this.getNodePackageName());
        File nodeDirectory = new File(this.getOutputDirectory(), nodePackage.replace('.', File.separatorChar));
        String visitorPackage = grammarInfo.resolvePackageName(this.getVisitorPackageName());
        File visitorDirectory = new File(this.getOutputDirectory(), visitorPackage.replace('.', File.separatorChar));
        JTB jtb = this.newJTB();
        jtb.setInputFile(jtbFile);
        jtb.setOutputDirectory(jjDirectory);
        jtb.setNodeDirectory(nodeDirectory);
        jtb.setVisitorDirectory(visitorDirectory);
        jtb.setNodePackageName(nodePackage);
        jtb.setVisitorPackageName(visitorPackage);
        jtb.run();
        this.createTimestamp(grammarInfo);
    }

    private String getNodePackageName() {
        if (this.packageName != null) {
            return this.packageName + ".syntaxtree";
        }
        if (this.nodePackageName != null) {
            return this.nodePackageName;
        }
        return "*.syntaxtree";
    }

    private String getVisitorPackageName() {
        if (this.packageName != null) {
            return this.packageName + ".visitor";
        }
        if (this.visitorPackageName != null) {
            return this.visitorPackageName;
        }
        return "*.visitor";
    }

    private JTB newJTB() {
        JTB jtb = new JTB();
        jtb.setLog(this.getLog());
        jtb.setDescriptiveFieldNames(this.descriptiveFieldNames);
        jtb.setJavadocFriendlyComments(this.javadocFriendlyComments);
        jtb.setNodeParentClass(this.nodeParentClass);
        jtb.setParentPointers(this.parentPointers);
        jtb.setPrinter(this.printer);
        jtb.setScheme(this.scheme);
        jtb.setSpecialTokens(this.specialTokens);
        jtb.setSupressErrorChecking(this.supressErrorChecking);
        return jtb;
    }
}

