/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.data;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.javafp.data.ListAdaptor;

public abstract class IList<T>
implements Iterable<T> {
    public static <T> IList<T> empty() {
        return Empty.EMPTY;
    }

    public static <T> IList<T> of() {
        return IList.empty();
    }

    public static <T> NonEmpty<T> of(T elem) {
        return IList.empty().add(Objects.requireNonNull(elem));
    }

    public static <T> NonEmpty<T> of(T ... elems) {
        IList<T> list = IList.empty();
        for (int i = elems.length - 1; i >= 0; --i) {
            list = list.add(Objects.requireNonNull(elems[i]));
        }
        return (NonEmpty)list;
    }

    public static <T> IList<T> of(Iterable<T> elems) {
        IList<T> list = IList.empty();
        for (T elem : elems) {
            list = list.add(Objects.requireNonNull(elem));
        }
        return list.reverse();
    }

    public static <T> IList<T> concat(IList<? extends T> listA, IList<? extends T> listB) {
        IList<T> list = listB;
        for (T elem : listA.reverse()) {
            list = list.add(elem);
        }
        return list;
    }

    public static String listToString(IList<Character> list) {
        StringBuilder sb = new StringBuilder();
        while (!list.isEmpty()) {
            sb.append(list.head());
            list = list.tail();
        }
        return sb.toString();
    }

    public static IList<Character> listToString(String s) {
        IList<Character> list = IList.empty();
        for (int i = s.length() - 1; i >= 0; --i) {
            list = list.add(Character.valueOf(s.charAt(i)));
        }
        return list;
    }

    public NonEmpty<T> add(T head) {
        return new NonEmpty<T>(head, this);
    }

    public IList<T> addAll(IList<T> head) {
        IList<T> l = head.reverse();
        NonEmpty<T> res = this;
        while (!l.isEmpty()) {
            res = res.add(l.head());
            l = l.tail();
        }
        return res;
    }

    public abstract boolean isEmpty();

    public abstract Optional<NonEmpty<T>> nonEmpty();

    public abstract T head();

    public abstract IList<T> tail();

    public abstract T get(int var1);

    protected abstract StringBuilder asString(StringBuilder var1);

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return false;
        }
        return this.equals((IList)rhs);
    }

    public abstract boolean equals(IList<T> var1);

    public abstract <S> S match(Function<NonEmpty<T>, S> var1, Function<Empty<T>, S> var2);

    public abstract IList<T> append(IList<T> var1);

    public abstract int size();

    public abstract IList<T> reverse();

    public abstract <U> IList<U> map(Function<? super T, ? extends U> var1);

    public abstract <U> U foldr(BiFunction<T, U, U> var1, U var2);

    public abstract <U> U foldl(BiFunction<U, T, U> var1, U var2);

    public abstract T foldr1(BinaryOperator<T> var1);

    public abstract T foldl1(BinaryOperator<T> var1);

    @Override
    public abstract Spliterator<T> spliterator();

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public abstract Iterator<T> iterator();

    public abstract List<T> toList();

    public static final class NonEmpty<T>
    extends IList<T> {
        public final T head;
        public final IList<T> tail;

        NonEmpty(T head, IList<T> tail) {
            this.head = Objects.requireNonNull(head);
            this.tail = Objects.requireNonNull(tail);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Optional<NonEmpty<T>> nonEmpty() {
            return Optional.of(this);
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public IList<T> tail() {
            return this.tail;
        }

        @Override
        public T get(int index) {
            Supplier<RuntimeException> raiseError = () -> new IndexOutOfBoundsException("Index " + index + " out of bounds");
            if (index < 0) {
                throw raiseError.get();
            }
            if (index == 0) {
                return this.head;
            }
            IList<T> next = this.tail;
            for (int i = 1; i < index; ++i) {
                if (next.isEmpty()) {
                    throw raiseError.get();
                }
                next = ((NonEmpty)next).tail;
            }
            if (next.isEmpty()) {
                throw raiseError.get();
            }
            return ((NonEmpty)next).head;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            this.asString(sb).setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        protected StringBuilder asString(StringBuilder sb) {
            return this.tail.asString(sb.append(this.head).append(','));
        }

        @Override
        public boolean equals(IList<T> rhs) {
            if (rhs.isEmpty()) {
                return false;
            }
            for (T lhs : this) {
                if (rhs.isEmpty() || !lhs.equals(rhs.head())) {
                    return false;
                }
                rhs = rhs.tail();
            }
            return rhs.isEmpty();
        }

        @Override
        public <S> S match(Function<NonEmpty<T>, S> nonEmpty, Function<Empty<T>, S> empty) {
            return nonEmpty.apply(this);
        }

        @Override
        public IList<T> append(IList<T> l) {
            return new NonEmpty<T>(this.head, this.tail.append(l));
        }

        @Override
        public int size() {
            IList pos = this;
            int length = 0;
            while (!((IList)pos).isEmpty()) {
                ++length;
                pos = ((IList)pos).tail();
            }
            return length;
        }

        @Override
        public IList<T> reverse() {
            IList result = IList.of();
            IList next = this;
            while (!((IList)next).isEmpty()) {
                result = result.add(((IList)next).head());
                next = ((IList)next).tail();
            }
            return result;
        }

        @Override
        public <U> IList<U> map(Function<? super T, ? extends U> f) {
            IList<U> result = IList.empty();
            IList next = this;
            while (!((IList)next).isEmpty()) {
                result = result.add(f.apply(((IList)next).head()));
                next = ((IList)next).tail();
            }
            return result.reverse();
        }

        @Override
        public <U> U foldr(BiFunction<T, U, U> f, U z) {
            return f.apply(this.head, this.tail.foldr(f, z));
        }

        @Override
        public <U> U foldl(BiFunction<U, T, U> f, U z) {
            U r = z;
            IList l = this;
            while (!((IList)l).isEmpty()) {
                r = f.apply(r, ((IList)l).head());
                l = ((IList)l).tail();
            }
            return r;
        }

        @Override
        public T foldr1(BinaryOperator<T> f) {
            return (T)this.tail.nonEmpty().map(tl -> f.apply(this.head, tl.foldr1(f))).orElse(this.head);
        }

        @Override
        public T foldl1(BinaryOperator<T> f) {
            Object r = null;
            IList l = this;
            while (!((IList)l).isEmpty()) {
                r = r == null ? (Object)((IList)l).head() : (Object)f.apply(r, ((IList)l).head());
                l = ((IList)l).tail();
            }
            return r;
        }

        @Override
        public Spliterator<T> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.size(), 1088);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                IList<T> pos;
                {
                    this.pos = this;
                }

                @Override
                public boolean hasNext() {
                    return !this.pos.isEmpty();
                }

                @Override
                public T next() {
                    Object head = this.pos.head();
                    this.pos = this.pos.tail();
                    return head;
                }
            };
        }

        @Override
        public List<T> toList() {
            return new ListAdaptor(this);
        }
    }

    public static final class Empty<T>
    extends IList<T> {
        static final Empty EMPTY = new Empty();

        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Optional<NonEmpty<T>> nonEmpty() {
            return Optional.empty();
        }

        @Override
        public T head() {
            throw new UnsupportedOperationException("Cannot take the head of an empty list");
        }

        @Override
        public IList<T> tail() {
            throw new UnsupportedOperationException("Cannot take the tail of an empty list");
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for an " + this.size() + " element list");
        }

        public String toString() {
            return "[]";
        }

        @Override
        public boolean equals(IList<T> rhs) {
            return rhs.isEmpty();
        }

        @Override
        protected StringBuilder asString(StringBuilder sb) {
            return sb;
        }

        @Override
        public <S> S match(Function<NonEmpty<T>, S> nonEmpty, Function<Empty<T>, S> empty) {
            return empty.apply(this);
        }

        @Override
        public IList<T> append(IList<T> l) {
            return l;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public IList<T> reverse() {
            return EMPTY;
        }

        @Override
        public <U> IList<U> map(Function<? super T, ? extends U> f) {
            return EMPTY;
        }

        @Override
        public <U> U foldr(BiFunction<T, U, U> f, U z) {
            return z;
        }

        @Override
        public <U> U foldl(BiFunction<U, T, U> f, U z) {
            return z;
        }

        @Override
        public T foldr1(BinaryOperator<T> f) {
            throw new UnsupportedOperationException("Cannot call foldr1 on an empty list");
        }

        @Override
        public T foldl1(BinaryOperator<T> f) {
            throw new UnsupportedOperationException("Cannot call foldl1 on an empty list");
        }

        @Override
        public Spliterator<T> spliterator() {
            return new Spliterator<T>(){

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    return false;
                }

                @Override
                public Spliterator<T> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return this.size();
                }

                @Override
                public int characteristics() {
                    return 1088;
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public List<T> toList() {
            return Collections.emptyList();
        }
    }
}

