/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.javafp.data.IList;
import org.javafp.data.Unit;
import org.javafp.parsecj.ConsumedT;
import org.javafp.parsecj.Merge;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.Parser;
import org.javafp.parsecj.Reply;
import org.javafp.parsecj.input.Input;

public abstract class Combinators {
    private static final String eofName = "EOF";
    private static final String testName = "<test>";

    public static <I, A> Reply<I, A> endOfInput(Input<I> input, String expected) {
        return Reply.error(Message.lazy(() -> Message.endOfInput(input.position(), expected)));
    }

    public static <I, A> Parser<I, A> retn(A x) {
        return input -> ConsumedT.empty(Reply.ok(x, input, Message.lazy(() -> Message.of(input.position()))));
    }

    public static <I, A, B> Parser<I, B> bind(Parser<I, ? extends A> p, Function<A, Parser<I, B>> f) {
        return input -> {
            ConsumedT cons1 = p.apply(input);
            if (cons1.isConsumed()) {
                return ConsumedT.consumed(() -> cons1.getReply().match(ok1 -> {
                    ConsumedT cons2 = ((Parser)f.apply(ok1.result)).apply(ok1.rest);
                    return cons2.getReply();
                }, error -> error.cast()));
            }
            return cons1.getReply().match(ok1 -> {
                ConsumedT cons2 = ((Parser)f.apply(ok1.result)).apply(ok1.rest);
                if (cons2.isConsumed()) {
                    return cons2;
                }
                return cons2.getReply().match(ok2 -> Merge.mergeOk(ok2.result, ok2.rest, ok1.msg, ok2.msg), error -> Merge.mergeError(ok1.msg, error.msg));
            }, error -> ConsumedT.empty(error.cast()));
        };
    }

    public static <I, A, B> Parser<I, B> then(Parser<I, ? extends A> p, Parser<I, B> q) {
        return input -> {
            ConsumedT cons1 = p.apply(input);
            if (cons1.isConsumed()) {
                return ConsumedT.consumed(() -> cons1.getReply().match(ok1 -> {
                    ConsumedT cons2 = q.apply(ok1.rest);
                    return cons2.getReply();
                }, error -> error.cast()));
            }
            return cons1.getReply().match(ok1 -> {
                ConsumedT cons2 = q.apply(ok1.rest);
                if (cons2.isConsumed()) {
                    return cons2;
                }
                return cons2.getReply().match(ok2 -> Merge.mergeOk(ok2.result, ok2.rest, ok1.msg, ok2.msg), error2 -> Merge.mergeError(ok1.msg, error2.msg));
            }, error -> cons1.cast());
        };
    }

    public static <I, A, B> Parser<I, B> map(Parser<I, A> p, Function<A, B> f) {
        return p.bind(f.andThen(Combinators::retn));
    }

    public static <I, A> Parser<I, A> safe(Parser<I, A> p) {
        return input -> {
            try {
                return p.apply(input);
            }
            catch (Message.Exception ex) {
                return ConsumedT.empty(Reply.error(ex.message));
            }
        };
    }

    public static <I, A> Parser<I, A> safeRetn(Supplier<A> supplier, String expected) {
        return input -> {
            try {
                return ConsumedT.empty(Reply.ok(supplier.get(), input, Message.lazy(() -> Message.of(input.position()))));
            }
            catch (Exception ex) {
                return ConsumedT.empty(Reply.error(Message.of(input.position(), input.current(), expected)));
            }
        };
    }

    public static <I, A> Parser<I, A> fail() {
        return input -> ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(input.position()))));
    }

    public static <I, A> Parser<I, A> fail(String msg) {
        return input -> ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(msg, input.position()))));
    }

    public static <I> Parser<I, Unit> eof() {
        return input -> {
            if (input.end()) {
                return ConsumedT.empty(Reply.ok(input, Message.lazy(() -> Message.of(input.position(), eofName))));
            }
            return ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(input.position(), input.current(), eofName))));
        };
    }

    public static <I> Parser<I, I> satisfy(Predicate<I> test) {
        return input -> {
            if (!input.end()) {
                Object s = input.current();
                if (test.test(s)) {
                    Input newInput = input.next();
                    return ConsumedT.consumed(() -> Reply.ok(s, newInput, Message.lazy(() -> Message.of(input.position()))));
                }
                return ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(input.position(), input.current(), testName))));
            }
            return ConsumedT.empty(Combinators.endOfInput(input, testName));
        };
    }

    public static <I> Parser<I, I> satisfy(I value) {
        return Combinators.label(Combinators.satisfy(value::equals), value.toString());
    }

    public static <I, A> Parser<I, A> satisfy(I value, A result) {
        return Combinators.satisfy(value).then(Combinators.retn(result));
    }

    public static <I, A> Parser<I, A> or(Parser<I, ? extends A> p, Parser<I, ? extends A> q) {
        return input -> {
            ConsumedT cons1 = p.apply(input);
            if (cons1.isConsumed()) {
                return cons1.cast();
            }
            return cons1.getReply().match(ok1 -> {
                ConsumedT cons2 = q.apply(input);
                if (cons2.isConsumed()) {
                    return cons2.cast();
                }
                return Merge.mergeOk(ok1.result, ok1.rest, ok1.msg, cons2.getReply().msg).cast();
            }, error1 -> {
                ConsumedT cons2 = q.apply(input);
                if (cons2.isConsumed()) {
                    return cons2.cast();
                }
                return cons2.getReply().match(ok2 -> Merge.mergeOk(ok2.result, ok2.rest, error1.msg, ok2.msg), error2 -> Merge.mergeError(error1.msg, error2.msg)).cast();
            });
        };
    }

    public static <I, A> Parser<I, A> label(Parser<I, A> p, String name) {
        return input -> {
            ConsumedT cons = p.apply(input);
            if (cons.isConsumed()) {
                return cons;
            }
            return cons.getReply().match(ok -> ConsumedT.empty(Reply.ok(ok.result, ok.rest, ok.msg.expect(name))), error -> ConsumedT.empty(Reply.error(error.msg.expect(name))));
        };
    }

    public static <I, A> Parser<I, A> attempt(Parser<I, A> p) {
        return input -> {
            ConsumedT cons = p.apply(input);
            if (cons.isConsumed()) {
                return cons.getReply().match(ok -> cons, error -> ConsumedT.empty(error));
            }
            return cons;
        };
    }

    public static <I, A> Parser<I, A> choice(IList<Parser<I, A>> ps) {
        if (ps.tail().isEmpty()) {
            return ps.head();
        }
        return Combinators.or(ps.head(), Combinators.choice(ps.tail()));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2) {
        return Combinators.or(p1, p2);
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2, Parser<I, ? extends A> p3) {
        return Combinators.or(p1, Combinators.or(p2, p3));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2, Parser<I, ? extends A> p3, Parser<I, ? extends A> p4) {
        return Combinators.or(p1, Combinators.or(p2, Combinators.or(p3, p4)));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2, Parser<I, ? extends A> p3, Parser<I, ? extends A> p4, Parser<I, ? extends A> p5) {
        return Combinators.or(p1, Combinators.or(p2, Combinators.or(p3, Combinators.or(p4, p5))));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2, Parser<I, ? extends A> p3, Parser<I, ? extends A> p4, Parser<I, ? extends A> p5, Parser<I, ? extends A> p6) {
        return Combinators.or(p1, Combinators.or(p2, Combinators.or(p3, Combinators.or(p4, Combinators.or(p5, p6)))));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, ? extends A> p1, Parser<I, ? extends A> p2, Parser<I, ? extends A> p3, Parser<I, ? extends A> p4, Parser<I, ? extends A> p5, Parser<I, ? extends A> p6, Parser<I, ? extends A> p7) {
        return Combinators.or(p1, Combinators.or(p2, Combinators.or(p3, Combinators.or(p4, Combinators.or(p5, Combinators.or(p6, p7))))));
    }

    public static <I, A> Parser<I, A> choice(Parser<I, A> ... ps) {
        return Combinators.choice(IList.of(ps));
    }

    public static <I, A> Parser<I, A> option(Parser<I, A> p, A x) {
        return Combinators.or(p, Combinators.retn(x));
    }

    public static <I, A> Parser<I, Optional<A>> optionalOpt(Parser<I, A> p) {
        return Combinators.option(Combinators.bind(p, x -> Combinators.retn(Optional.of(x))), Optional.empty());
    }

    public static <I, A> Parser<I, Boolean> optBool(Parser<I, A> p) {
        return Combinators.option(Combinators.bind(p, x -> Combinators.retn(Boolean.TRUE)), Boolean.FALSE);
    }

    public static <I, A> Parser<I, Unit> optional(Parser<I, A> p) {
        return Combinators.or(Combinators.bind(p, x -> Combinators.retn(Unit.unit)), Combinators.retn(Unit.unit));
    }

    public static <I, A, OPEN, CLOSE> Parser<I, A> between(Parser<I, OPEN> open, Parser<I, CLOSE> close, Parser<I, A> p) {
        return Combinators.then(open, Combinators.bind(p, a -> Combinators.then(close, Combinators.retn(a))));
    }

    public static <I, A> Parser<I, IList<A>> many(Parser<I, A> p) {
        return Combinators.manyLoop(p, IList.of());
    }

    public static <I, A> Parser<I, IList<A>> many1(Parser<I, A> p) {
        return Combinators.bind(p, x -> Combinators.manyLoop(p, IList.of(x)));
    }

    private static <I, A> Parser<I, IList<A>> manyLoop(Parser<I, A> p, IList<A> acc) {
        return Combinators.manyLoop(p, acc, -1);
    }

    private static <I, A> Parser<I, IList<A>> manyLoop(Parser<I, A> p, IList<A> acc, int count) {
        return input -> {
            int i;
            IList.NonEmpty acc2 = acc;
            boolean consumed = false;
            boolean done = false;
            for (i = 0; !done && i != count; ++i) {
                Reply.Ok ok;
                Reply reply;
                ConsumedT cons = p.apply(input);
                if (cons.isConsumed()) {
                    consumed = true;
                    reply = cons.getReply();
                    if (reply.isOk()) {
                        ok = (Reply.Ok)reply;
                        acc2 = acc2.add(ok.result);
                        input = ok.rest;
                        continue;
                    }
                    return cons.cast();
                }
                reply = cons.getReply();
                if (reply.isOk()) {
                    ok = (Reply.Ok)reply;
                    acc2 = acc2.add(ok.result);
                    input = ok.rest;
                    continue;
                }
                done = true;
                --i;
            }
            IList.NonEmpty acc3 = acc2;
            Input input2 = input;
            if (count == -1 || i == count) {
                return ConsumedT.of(consumed, () -> Reply.ok(acc3.reverse(), input2, Message.lazy(() -> Message.of(input2.position()))));
            }
            return ConsumedT.of(consumed, () -> Reply.error(Message.lazy(() -> Message.of(input2.position()))));
        };
    }

    public static <I, A> Parser<I, Unit> skipMany(Parser<I, A> p) {
        return input -> {
            boolean consumed = false;
            while (true) {
                Reply.Ok ok;
                Reply reply;
                ConsumedT cons;
                if ((cons = p.apply(input)).isConsumed()) {
                    consumed = true;
                    reply = cons.getReply();
                    if (reply.isOk()) {
                        ok = (Reply.Ok)reply;
                        input = ok.rest;
                        continue;
                    }
                    return cons.cast();
                }
                reply = cons.getReply();
                if (!reply.isOk()) break;
                ok = (Reply.Ok)reply;
                input = ok.rest;
            }
            Input input2 = input;
            return ConsumedT.of(consumed, () -> Reply.ok(Unit.unit, input2, Message.lazy(() -> Message.of(input2.position()))));
        };
    }

    public static <I, A> Parser<I, Unit> skipMany1(Parser<I, A> p) {
        return Combinators.then(p, Combinators.skipMany(p));
    }

    public static <I, A, SEP> Parser<I, IList<A>> sepBy(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.or(Combinators.sepBy1(p, sep), Combinators.retn(IList.of()));
    }

    public static <I, A, SEP> Parser<I, IList<A>> sepBy1(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.bind(p, x -> Combinators.bind(Combinators.many(Combinators.then(sep, p)), xs -> Combinators.retn(xs.add(x))));
    }

    public static <I, A, SEP> Parser<I, IList<A>> sepEndBy(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.or(Combinators.sepEndBy1(p, sep), Combinators.retn(IList.of()));
    }

    public static <I, A, SEP> Parser<I, IList<A>> sepEndBy1(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.bind(p, x -> Combinators.or(Combinators.then(sep, Combinators.bind(Combinators.sepEndBy(p, sep), xs -> Combinators.retn(xs.add(x)))), Combinators.retn(IList.of(x))));
    }

    public static <I, A, SEP> Parser<I, IList<A>> endBy(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.many(Combinators.bind(p, x -> Combinators.then(sep, Combinators.retn(x))));
    }

    public static <I, A, SEP> Parser<I, IList<A>> endBy1(Parser<I, A> p, Parser<I, SEP> sep) {
        return Combinators.many1(Combinators.bind(p, x -> Combinators.then(sep, Combinators.retn(x))));
    }

    public static <I, A> Parser<I, IList<A>> count(Parser<I, A> p, int n) {
        return Combinators.manyLoop(p, IList.of(), n);
    }

    public static <I, A> Parser<I, A> chainr(Parser<I, A> p, Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.or(Combinators.chainr1(p, op), Combinators.retn(x));
    }

    public static <I, A> Parser<I, A> chainl(Parser<I, A> p, Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.or(Combinators.chainl1(p, op), Combinators.retn(x));
    }

    public static <I, A> Parser<I, A> chainr1(Parser<I, A> p, Parser<I, BinaryOperator<A>> op) {
        return Combinators.scanr1(p, op);
    }

    private static <I, A> Parser<I, A> scanr1(Parser<I, A> p, Parser<I, BinaryOperator<A>> op) {
        return Combinators.bind(p, x -> Combinators.restr1(p, op, x));
    }

    private static <I, A> Parser<I, A> restr1(Parser<I, A> p, Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.or(Combinators.bind(op, f -> Combinators.bind(Combinators.scanr1(p, op), y -> Combinators.retn(f.apply(x, y)))), Combinators.retn(x));
    }

    public static <I, A> Parser<I, A> chainl1(Parser<I, A> p, Parser<I, BinaryOperator<A>> op) {
        return Combinators.bind(p, x -> Combinators.restl1(p, op, x));
    }

    private static <I, A> Parser<I, A> restl1(Parser<I, A> p, Parser<I, BinaryOperator<A>> op, A x) {
        return Combinators.or(Combinators.bind(op, f -> Combinators.bind(p, y -> Combinators.restl1(p, op, f.apply(x, y)))), Combinators.retn(x));
    }
}

