/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.Set;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.utils.Folds;

final class EndOfInput<I>
implements Message<I> {
    public final int pos;
    public final Set<String> expected;

    EndOfInput(int pos, Set<String> expected) {
        this.pos = pos;
        this.expected = expected;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public I symbol() {
        return null;
    }

    @Override
    public Set<String> expected() {
        return this.expected;
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs == null) {
            return false;
        }
        if (!(rhs instanceof EndOfInput)) {
            return false;
        }
        EndOfInput message = (EndOfInput)rhs;
        if (this.pos != message.pos) {
            return false;
        }
        return this.expected.equals(message.expected);
    }

    public int hashCode() {
        int result = this.pos;
        result = 31 * result + this.expected.hashCode();
        return result;
    }

    public String toString() {
        String expectedStr = this.expected.isEmpty() ? "" : Folds.foldRight1((x, y) -> x + ',' + y, this.expected);
        return "\"Unexpected EOF at position " + this.pos + ". Expecting one of [" + expectedStr + ']';
    }
}

