/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javafp.data.Unit;
import org.javafp.parsecj.Combinators;
import org.javafp.parsecj.ConsumedT;
import org.javafp.parsecj.LazyMessage;
import org.javafp.parsecj.Message;
import org.javafp.parsecj.Parser;
import org.javafp.parsecj.Reply;
import org.javafp.parsecj.input.CharInput;
import org.javafp.parsecj.input.Input;

public abstract class Text {
    public static final Parser<Character, Character> alpha = Combinators.satisfy(c -> Character.isAlphabetic(c.charValue())).label("alpha");
    public static final Parser<Character, Character> digit = Combinators.satisfy(c -> Character.isDigit(c.charValue())).label("digit");
    public static final Parser<Character, Character> space = Combinators.satisfy(c -> Character.isSpaceChar(c.charValue())).label("space");
    public static final Parser<Character, Character> wspace = Combinators.satisfy(c -> Character.isWhitespace(c.charValue())).label("wspace");
    public static final Parser<Character, Unit> wspaces = Combinators.skipMany(wspace);
    private static final String INTEGER_REGEX = "-?\\d+";
    private static final String DOUBLE_REGEX = "-?(\\d+(\\.\\d*)?|\\d*\\.\\d+)([eE][+-]?\\d+)?[fFdD]?";
    private static final Parser<Character, String> matchDouble = Text.regex("-?(\\d+(\\.\\d*)?|\\d*\\.\\d+)([eE][+-]?\\d+)?[fFdD]?");
    public static final Parser<Character, Integer> intr = Combinators.bind(Text.regex("-?\\d+"), s -> Text.safeRetn(Integer::valueOf, s, "integer")).label("integer");
    public static final Parser<Character, Long> lng = Combinators.bind(Text.regex("-?\\d+"), s -> Text.safeRetn(Long::valueOf, s, "long")).label("long");
    public static final Parser<Character, Double> dble = Combinators.bind(matchDouble, s -> Text.safeRetn(Double::valueOf, s, "double")).label("double");
    public static final Parser<Character, Number> number = Combinators.bind(matchDouble, s -> Text.safeRetn(ds -> {
        Double d = Double.valueOf(ds);
        long l = d.longValue();
        if ((double)l == d) {
            return l;
        }
        return d;
    }, s, "number")).label("number");
    public static final Parser<Character, String> alphaNum = state -> {
        if (state.end()) {
            return ConsumedT.empty(Combinators.endOfInput(state, "alphaNum"));
        }
        char c = ((Character)state.current()).charValue();
        if (!Character.isAlphabetic(c) && !Character.isDigit(c)) {
            Input tail = state;
            return ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(tail.position(), tail.current(), "alphaNum"))));
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(c);
        } while (!(state = state.next()).end() && (Character.isAlphabetic(c = ((Character)state.current()).charValue()) || Character.isDigit(c)));
        Input tail = state;
        return ConsumedT.consumed(() -> Reply.ok(sb.toString(), tail, Message.lazy(() -> Message.of(tail.position()))));
    };

    private static <I, A> ConsumedT<I, A> consError(boolean consumed, Input<I> input, String expected) {
        LazyMessage msg = Message.lazy(() -> Message.of(input.position(), input.current(), expected));
        return ConsumedT.of(consumed, () -> Reply.error(msg));
    }

    private static <I, A> ConsumedT<I, A> eofError(boolean consumed, Input<I> input, String expected) {
        return ConsumedT.of(consumed, () -> Combinators.endOfInput(input, expected));
    }

    public static Parser<Character, Character> chr(char c) {
        return Combinators.satisfy(Character.valueOf(c));
    }

    private static <A> Parser<Character, A> safeRetn(Function<String, A> f, String s, String expected) {
        return input -> {
            try {
                Object val = f.apply(s);
                return ConsumedT.empty(Reply.ok(val, input, Message.lazy(() -> Message.of(input.position()))));
            }
            catch (Exception ex) {
                return ConsumedT.empty(Reply.error(Message.lazy(() -> Message.of(input.position(), input.current(), expected))));
            }
        };
    }

    public static Parser<Character, String> string(String value) {
        Parser p = state -> {
            if (state.end()) {
                return ConsumedT.empty(Combinators.endOfInput(state, value));
            }
            boolean consumed = false;
            char c = ((Character)state.current()).charValue();
            int i = 0;
            while (c == value.charAt(i)) {
                consumed = true;
                state = state.next();
                if (++i == value.length()) {
                    Input tail = state;
                    return ConsumedT.consumed(() -> Reply.ok(value, tail, Message.lazy(() -> Message.of(tail.position()))));
                }
                if (state.end()) {
                    return Text.eofError(consumed, state, value);
                }
                c = ((Character)state.current()).charValue();
            }
            return Text.consError(consumed, state, "\"" + value + '\"');
        };
        return p.label(value);
    }

    public static Parser<Character, String> regex(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return state -> {
            if (!(state instanceof CharInput)) {
                throw new RuntimeException("regex only supported on CharState inputs");
            }
            CharInput charState = (CharInput)state;
            CharSequence cs = charState.getCharSequence();
            Matcher matcher = pattern.matcher(cs);
            LazyMessage msg = Message.lazy(() -> Message.of(state.position(), state.current(), "Regex('" + regex + "')"));
            if (matcher.lookingAt()) {
                int end = matcher.end();
                String str = cs.subSequence(0, end).toString();
                return ConsumedT.consumed(() -> Reply.ok(str, state.next(end), msg));
            }
            return ConsumedT.empty(Reply.error(msg));
        };
    }

    public static Parser<Character, String> strBetween(Parser<Character, Character> open, Parser<Character, Character> close) {
        return state -> {
            ConsumedT cons2;
            if (state.end()) {
                return ConsumedT.empty(Combinators.endOfInput(state, "strBetween"));
            }
            ConsumedT cons = open.apply(state);
            if (cons.getReply().isError()) {
                return cons.cast();
            }
            Input input2 = ((Reply.Ok)cons.getReply()).rest;
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (input2.end()) {
                    Input input3 = input2;
                    return ConsumedT.consumed(() -> Combinators.endOfInput(input3, "<char>"));
                }
                cons2 = close.apply(input2);
                if (cons2.getReply().isOk()) break;
                sb.append(input2.current());
                input2 = input2.next();
            }
            input2 = ((Reply.Ok)cons2.getReply()).rest;
            Input tail = input2;
            return ConsumedT.consumed(() -> Reply.ok(sb.toString(), tail, Message.lazy(() -> Message.of(tail.position()))));
        };
    }
}

