/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj.input;

import java.util.ArrayList;
import java.util.List;
import org.javafp.parsecj.input.CharInput;

public class StringInput
implements CharInput {
    protected final String symbols;
    protected final int pos;

    StringInput(String symbols, int pos) {
        this.symbols = symbols;
        this.pos = pos;
    }

    StringInput(String symbols) {
        this(symbols, 0);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public boolean end() {
        return this.pos >= this.symbols.length();
    }

    @Override
    public Character current() {
        return this.pos < this.symbols.length() ? Character.valueOf(this.symbols.charAt(this.pos)) : null;
    }

    @Override
    public List<Character> current(int n) {
        ArrayList<Character> chars = new ArrayList<Character>(n);
        for (int i = this.pos; i < this.pos + n; ++i) {
            chars.add(Character.valueOf(this.symbols.charAt(i)));
        }
        return chars;
    }

    public StringInput next() {
        return new StringInput(this.symbols, this.pos + 1);
    }

    public StringInput next(int n) {
        return new StringInput(this.symbols, this.pos + n);
    }

    @Override
    public CharSequence getCharSequence() {
        return this.symbols.substring(this.pos);
    }

    @Override
    public CharSequence getCharSequence(int length) {
        return this.symbols.substring(this.pos, this.pos + length);
    }
}

