/*
 * Decompiled with CFR 0.152.
 */
package org.javafp.parsecj.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Sets {
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    public static <T> Set<T> empty() {
        return Collections.emptySet();
    }

    public static <T> Set<T> singleton(T value) {
        return Collections.singleton(value);
    }

    public static <T> Set<T> union(Set<? extends T> lhs, Set<? extends T> rhs, Set<T> out) {
        out.addAll(lhs);
        out.addAll(rhs);
        return out;
    }

    public static <T> Set<T> union(Set<T> lhs, Set<T> rhs) {
        if (SortedSet.class.isAssignableFrom(lhs.getClass()) && SortedSet.class.isAssignableFrom(rhs.getClass())) {
            SortedSet lhsSS = (SortedSet)lhs;
            SortedSet rhsSS = (SortedSet)rhs;
            TreeSet ts = lhsSS.comparator().equals(rhsSS.comparator()) ? new TreeSet(lhsSS.comparator()) : new TreeSet();
            return Sets.union(lhsSS, rhsSS, ts);
        }
        HashSet<T> ts = new HashSet<T>(Sets.capacity(lhs.size() + rhs.size()));
        ts.addAll(lhs);
        ts.addAll(rhs);
        return ts;
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

