/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.javalite.instrumentation.Instrumentation;

public class ActiveJdbcInstrumentationPlugin
extends AbstractMojo {
    private String outputDirectory;
    private String[] outputDirectories;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.addCP();
            if (this.outputDirectories != null) {
                for (String directory : this.outputDirectories) {
                    this.instrument(directory);
                }
            } else if (this.outputDirectory != null) {
                this.instrument(this.outputDirectory);
            } else {
                this.instrument(this.project.getBuild().getOutputDirectory());
                this.instrument(this.project.getBuild().getTestOutputDirectory());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to add output directory to classpath", e);
        }
    }

    private void addCP() throws DependencyResolutionRequiredException, MalformedURLException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        for (Object runtimeClasspathElement : runtimeClasspathElements) {
            String element = (String)runtimeClasspathElement;
            this.addUrl(new File(element).toURI().toURL());
        }
    }

    private void addUrl(URL url) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ClassLoader realmLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Method addUrlMethod = realmLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
        addUrlMethod.setAccessible(true);
        addUrlMethod.invoke((Object)realmLoader, url);
    }

    private void instrument(String instrumentationDirectory) throws MalformedURLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!new File(instrumentationDirectory).exists()) {
            this.getLog().info((CharSequence)("Instrumentation: directory " + instrumentationDirectory + " does not exist, skipping"));
            return;
        }
        URL outDir = new File(instrumentationDirectory).toURI().toURL();
        this.addUrl(outDir);
        Instrumentation instrumentation = new Instrumentation();
        instrumentation.setOutputDirectory(instrumentationDirectory);
        instrumentation.instrument();
    }
}

