/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import org.javalite.instrumentation.Instrumentation;
import org.javalite.instrumentation.InstrumentationException;

public class InstrumentationModelFinder {
    private final CtClass modelClass;
    private final List<CtClass> models = new ArrayList<CtClass>();
    private final ClassPool cp = ClassPool.getDefault();
    private String currentDirectoryPath;

    protected InstrumentationModelFinder() throws NotFoundException, ClassNotFoundException {
        this.cp.insertClassPath(new ClassClassPath(Class.forName("org.javalite.activejdbc.Association")));
        this.modelClass = this.cp.get("org.javalite.activejdbc.Model");
    }

    protected void processURL(URL url) throws URISyntaxException, IOException, ClassNotFoundException {
        Instrumentation.log("Processing: " + url);
        File f = new File(url.toURI());
        if (f.isFile()) {
            this.processFilePath(f);
        } else {
            this.processDirectoryPath(f);
        }
    }

    private void processFilePath(File file) {
        try {
            if (file.getCanonicalPath().toLowerCase().endsWith(".jar") || file.getCanonicalPath().toLowerCase().endsWith(".zip")) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("class")) continue;
                    InputStream zin = zip.getInputStream(entry);
                    this.tryClass(entry.getName().replace(File.separatorChar, '.').substring(0, entry.getName().length() - 6));
                    zin.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void processDirectoryPath(File directory) throws IOException, ClassNotFoundException {
        this.currentDirectoryPath = directory.getCanonicalPath();
        this.processDirectory(directory);
    }

    private void processDirectory(File directory) throws IOException, ClassNotFoundException {
        this.findFiles(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.processDirectory(file);
            }
        }
    }

    private void findFiles(File directory) throws IOException, ClassNotFoundException {
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        if (files != null) {
            for (File file : files) {
                int current = this.currentDirectoryPath.length();
                String fileName = file.getCanonicalPath().substring(++current);
                String className = fileName.replace(File.separatorChar, '.').substring(0, fileName.length() - 6);
                this.tryClass(className);
            }
        }
    }

    protected void tryClass(String className) throws IOException, ClassNotFoundException {
        try {
            CtClass clazz = this.getClazz(className);
            if (this.isModel(clazz) && !this.models.contains(clazz)) {
                this.models.add(clazz);
                Instrumentation.log("Found model: " + className);
            }
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    protected CtClass getClazz(String className) throws NotFoundException {
        return this.cp.get(className);
    }

    protected boolean isModel(CtClass clazz) throws NotFoundException {
        return clazz != null && this.notAbstract(clazz) && clazz.subclassOf(this.modelClass) && !clazz.equals(this.modelClass);
    }

    private boolean notAbstract(CtClass clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers);
    }

    protected List<CtClass> getModels() {
        return this.models;
    }
}

