/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.javalite.instrumentation.Classes;
import org.javalite.instrumentation.InstrumentationException;

public class DBProxy {
    private Object db;
    private MethodHandle open;
    private MethodHandle name;
    private MethodHandle open4;
    private MethodHandle close;
    private boolean opened = false;

    DBProxy() {
        this(null);
    }

    DBProxy(String dbName) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this.db = dbName == null ? lookup.findConstructor(Classes.DB, MethodType.methodType(Void.TYPE)).invoke() : lookup.findConstructor(Classes.DB, MethodType.methodType(Void.TYPE, String.class)).invoke(dbName);
            this.open = lookup.findVirtual(Classes.DB, "open", MethodType.methodType(Classes.DB));
            this.name = lookup.findVirtual(Classes.DB, "name", MethodType.methodType(String.class));
            this.open4 = lookup.findVirtual(Classes.DB, "open", MethodType.methodType(Classes.DB, String.class, String.class, String.class, String.class));
            this.close = lookup.findVirtual(Classes.DB, "close", MethodType.methodType(Void.TYPE));
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected String name() {
        try {
            return this.name.invoke(this.db);
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected DBProxy open() {
        try {
            this.open.invoke(this.db);
            this.opened = true;
            return this;
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected DBProxy open(String driver, String url, String user, String password) {
        try {
            this.open4.invoke(this.db, driver, url, user, password);
            this.opened = true;
            return this;
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected void close() {
        try {
            if (this.opened) {
                this.close.invoke(this.db);
                this.opened = false;
            }
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }
}

