/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.javalite.activejdbc.DBProxy;
import org.javalite.activejdbc.RegistryProxy;
import org.javalite.instrumentation.DBParameters;
import org.javalite.instrumentation.Logger;

public class StaticMetadataGenerator {
    private List<DBParameters> dbParameters;

    public void setDBParameters(List<DBParameters> dbParameters) {
        this.dbParameters = dbParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String outputDirectory) {
        Path metadataPath = Paths.get(outputDirectory, "activejdbc_metadata.json");
        Logger.info("Saving static metadata to: " + metadataPath.toString());
        RegistryProxy registry = new RegistryProxy();
        try (DBProxy dbProxy = null;){
            Files.deleteIfExists(metadataPath);
            try {
                dbProxy = new DBProxy().open();
                registry.init(dbProxy.name());
                dbProxy.close();
            }
            catch (Throwable e) {
                if (this.dbParameters.isEmpty()) {
                    throw e;
                }
                Logger.info(e.getMessage());
            }
            finally {
                if (dbProxy != null) {
                    dbProxy.close();
                }
            }
            if (this.dbParameters != null) {
                for (DBParameters parameters : this.dbParameters) {
                    dbProxy = new DBProxy(parameters.getName()).open(parameters.getDriver(), parameters.getUrl(), parameters.getUsername(), parameters.getPassword());
                    registry.init(parameters.getName());
                    dbProxy.close();
                }
            }
            Files.write(metadataPath, registry.toJSON().getBytes(), new OpenOption[0]);
        }
    }
}

