/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.javalite.activejdbc.StaticMetadataGenerator;
import org.javalite.instrumentation.DBParameters;
import org.javalite.instrumentation.Instrumentation;
import org.javalite.instrumentation.Log;
import org.javalite.instrumentation.Logger;

public class ActiveJdbcInstrumentationPlugin
extends AbstractMojo {
    private String outputDirectory;
    private List<DBParameters> databases;
    private String[] outputDirectories;
    protected MavenProject project;
    private String basedir;
    private boolean generateStaticMetadata = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Logger.setLog(new Log(){

            @Override
            public void info(String s) {
                ActiveJdbcInstrumentationPlugin.this.getLog().info((CharSequence)s);
            }

            @Override
            public void error(String s) {
                ActiveJdbcInstrumentationPlugin.this.getLog().error((CharSequence)s);
            }
        });
        try {
            this.addCP();
            if (this.outputDirectories != null) {
                for (String directory : this.outputDirectories) {
                    this.instrument(directory);
                }
            } else if (this.outputDirectory != null) {
                this.instrument(this.outputDirectory);
                if (this.generateStaticMetadata) {
                    this.generateStaticMetadata(this.outputDirectory);
                }
            } else {
                this.instrument(this.project.getBuild().getOutputDirectory());
                if (this.generateStaticMetadata) {
                    this.generateStaticMetadata(this.project.getBuild().getOutputDirectory());
                }
                this.instrument(this.project.getBuild().getTestOutputDirectory());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to add output directory to classpath", e);
        }
    }

    private void addCP() throws DependencyResolutionRequiredException, MalformedURLException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        for (Object runtimeClasspathElement : runtimeClasspathElements) {
            String element = (String)runtimeClasspathElement;
            this.addUrl(new File(element).toURI().toURL());
        }
    }

    private void addUrl(URL url) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ClassLoader realmLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Method addUrlMethod = realmLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
        addUrlMethod.setAccessible(true);
        addUrlMethod.invoke((Object)realmLoader, url);
    }

    private void instrument(String instrumentationDirectory) throws MalformedURLException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!new File(instrumentationDirectory).exists()) {
            Logger.info("Output directory " + instrumentationDirectory + " does not exist, skipping");
            return;
        }
        URL outDir = new File(instrumentationDirectory).toURI().toURL();
        this.addUrl(outDir);
        Instrumentation instrumentation = new Instrumentation();
        instrumentation.setOutputDirectory(instrumentationDirectory);
        instrumentation.instrument();
    }

    private void generateStaticMetadata(String outputDirectory) {
        if (!new File(outputDirectory).exists()) {
            Logger.info("Output directory " + outputDirectory + " does not exist, skipping");
            return;
        }
        StaticMetadataGenerator generator = new StaticMetadataGenerator();
        generator.setDBParameters(this.databases);
        generator.generate(outputDirectory);
    }
}

