/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.List;
import javassist.CtClass;
import javassist.NotFoundException;
import org.javalite.instrumentation.Classes;
import org.javalite.instrumentation.InstrumentationException;
import org.javalite.instrumentation.InstrumentationModelFinder;
import org.javalite.instrumentation.Logger;
import org.javalite.instrumentation.ModelInstrumentation;

public class Instrumentation {
    private String outputDirectory;

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void instrument() {
        if (this.outputDirectory == null) {
            throw new RuntimeException("Property 'outputDirectory' must be provided");
        }
        try {
            Logger.info("**************************** START INSTRUMENTATION ****************************");
            Logger.info("Directory: " + this.outputDirectory);
            InstrumentationModelFinder mf = new InstrumentationModelFinder();
            File target = new File(this.outputDirectory);
            mf.processDirectoryPath(target);
            ModelInstrumentation mi = new ModelInstrumentation();
            for (CtClass clazz : mf.getModels()) {
                byte[] bytecode = mi.instrument(clazz);
                String fileName = this.getFullFilePath(clazz);
                FileOutputStream fout = new FileOutputStream(fileName);
                fout.write(bytecode);
                fout.flush();
                fout.close();
                Logger.info("Instrumented class: " + fileName);
            }
            Instrumentation.generateModelsFile(mf.getModels(), target);
            Logger.info("**************************** END INSTRUMENTATION ****************************");
        }
        catch (Throwable e) {
            throw new InstrumentationException(e);
        }
    }

    private String getFullFilePath(CtClass modelClass) throws NotFoundException, URISyntaxException {
        return modelClass.getURL().toURI().getPath();
    }

    private static void generateModelsFile(List<CtClass> models, File target) throws Throwable {
        FileOutputStream fout = new FileOutputStream(new File(target.getAbsolutePath(), "activejdbc_models.properties"));
        for (CtClass model : models) {
            fout.write((model.getName() + ":" + Instrumentation.getDatabaseName(model) + "\n").getBytes());
        }
        fout.close();
    }

    protected static String getDatabaseName(CtClass model) throws Throwable {
        Object annotation = model.getAnnotation(Classes.DbName);
        if (annotation != null) {
            Method valueMethod = annotation.getClass().getMethod("value", new Class[0]);
            return valueMethod.invoke(annotation, new Object[0]).toString();
        }
        return "default";
    }
}

