/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.SignatureAttribute;
import org.javalite.instrumentation.InstrumentationException;
import org.javalite.instrumentation.Logger;

public class ModelInstrumentation {
    private final CtClass modelClass;

    public ModelInstrumentation() throws NotFoundException {
        ClassPool cp = ClassPool.getDefault();
        cp.insertClassPath(new ClassClassPath(this.getClass()));
        this.modelClass = cp.get("org.javalite.activejdbc.Model");
    }

    public byte[] instrument(CtClass target) throws InstrumentationException {
        try {
            this.doInstrument(target);
            target.detach();
            return target.toBytecode();
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    private void doInstrument(CtClass target) throws NotFoundException, CannotCompileException {
        CtMethod[] modelMethods = this.modelClass.getDeclaredMethods();
        CtMethod[] targetMethods = target.getDeclaredMethods();
        CtMethod modelGetClass = this.modelClass.getDeclaredMethod("modelClass");
        CtMethod newGetClass = CtNewMethod.copy(modelGetClass, target, null);
        newGetClass.setBody("{ return " + target.getName() + ".class; }");
        ClassMap classMap = new ClassMap();
        classMap.fix(this.modelClass);
        CodeConverter conv = new CodeConverter();
        conv.redirectMethodCall(modelGetClass, newGetClass);
        for (CtMethod method : modelMethods) {
            CtMethod newMethod;
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (this.targetHasMethod(targetMethods, method)) {
                Logger.debug("Detected method: " + method.getName() + ", skipping delegate.");
                continue;
            }
            if (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers)) {
                newMethod = CtNewMethod.copy(method, target, classMap);
                newMethod.instrument(conv);
            } else {
                newMethod = "modelClass".equals(method.getName()) ? newGetClass : CtNewMethod.delegator(method, target);
            }
            for (AttributeInfo attr : method.getMethodInfo().getAttributes()) {
                if (!(attr instanceof SignatureAttribute)) continue;
                newMethod.getMethodInfo().addAttribute((SignatureAttribute)attr);
            }
            target.addMethod(newMethod);
        }
    }

    private boolean targetHasMethod(CtMethod[] targetMethods, CtMethod delegate) {
        for (CtMethod targetMethod : targetMethods) {
            if (!targetMethod.equals(delegate)) continue;
            return true;
        }
        return false;
    }
}

