/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.javalite.instrumentation.InstrumentationException;

public class RegistryProxy {
    private MethodHandle init;
    private MethodHandle toJSON;
    private Object registry;

    RegistryProxy() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> registryClass = Class.forName("org.javalite.activejdbc.Registry");
            this.registry = lookup.findStatic(registryClass, "instance", MethodType.methodType(registryClass)).invoke();
            this.init = lookup.findVirtual(registryClass, "init", MethodType.methodType(Void.TYPE, String.class));
            this.toJSON = lookup.findVirtual(registryClass, "metadataToJSON", MethodType.methodType(String.class));
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected void init(String dbName) {
        try {
            this.init.invoke(this.registry, dbName);
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }

    protected String toJSON() {
        try {
            return this.toJSON.invoke(this.registry);
        }
        catch (Throwable t) {
            throw new InstrumentationException(t);
        }
    }
}

