/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.javalite.instrumentation.InstrumentationException;
import org.javalite.instrumentation.Logger;

public class ModelInstrumentation {
    private static final String GENERATED_DATE_PATTERN = "yyyy-MM-dd'T'hh:mm:ss.SSSZZZ";
    private final CtClass modelClass;

    public ModelInstrumentation() throws NotFoundException {
        ClassPool cp = ClassPool.getDefault();
        cp.insertClassPath(new ClassClassPath(this.getClass()));
        this.modelClass = cp.get("org.javalite.activejdbc.Model");
    }

    public byte[] instrument(CtClass target) throws InstrumentationException {
        try {
            this.doInstrument(target);
            target.detach();
            return target.toBytecode();
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    private void doInstrument(CtClass target) throws NotFoundException, CannotCompileException {
        CtMethod[] modelMethods = this.modelClass.getDeclaredMethods();
        CtMethod[] targetMethods = target.getDeclaredMethods();
        CtMethod modelGetClass = this.modelClass.getDeclaredMethod("modelClass");
        CtMethod newGetClass = CtNewMethod.copy(modelGetClass, target, null);
        newGetClass.setBody("{ return " + target.getName() + ".class; }");
        ClassMap classMap = new ClassMap();
        classMap.fix(this.modelClass);
        CodeConverter conv = new CodeConverter();
        conv.redirectMethodCall(modelGetClass, newGetClass);
        for (CtMethod method : modelMethods) {
            CtMethod newMethod;
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            if (this.targetHasMethod(targetMethods, method)) {
                Logger.debug("Detected method: " + method.getName() + ", skipping delegate.");
                continue;
            }
            if (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers)) {
                newMethod = CtNewMethod.copy(method, target, classMap);
                newMethod.instrument(conv);
            } else {
                newMethod = "modelClass".equals(method.getName()) ? newGetClass : CtNewMethod.delegator(method, target);
            }
            for (AttributeInfo attr : method.getMethodInfo().getAttributes()) {
                if (!(attr instanceof SignatureAttribute)) continue;
                newMethod.getMethodInfo().addAttribute((SignatureAttribute)attr);
            }
            this.addGeneratedAnnotation(newMethod, target);
            target.addMethod(newMethod);
        }
    }

    private boolean targetHasMethod(CtMethod[] targetMethods, CtMethod delegate) {
        for (CtMethod targetMethod : targetMethods) {
            if (!targetMethod.equals(delegate)) continue;
            return true;
        }
        return false;
    }

    private void addGeneratedAnnotation(CtMethod generatedMethod, CtClass target) {
        ConstPool constPool = target.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation("javax.annotation.Generated", constPool);
        annot.addMemberValue("value", (MemberValue)new StringMemberValue("org.javalite.instrumentation.ModelInstrumentation", constPool));
        ZonedDateTime now = ZonedDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(GENERATED_DATE_PATTERN);
        annot.addMemberValue("date", (MemberValue)new StringMemberValue(now.format(formatter), constPool));
        attr.addAnnotation(annot);
        generatedMethod.getMethodInfo().addAttribute(attr);
    }
}

