/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InternalException;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.common.Convert;

public class RawPaginator
implements Serializable {
    private final int pageSize;
    private final String subQuery;
    private List<String> orderBys = new ArrayList<String>();
    private final Object[] params;
    private final String tableName;
    private int currentPage;
    private final String countQuery;
    private boolean suppressCounts;
    private Long count = 0L;
    private Dialect dialect;
    private String dbName;
    private String[] columns;

    public RawPaginator(String tableName, String[] columns, int pageSize, String subQuery, Object ... params) {
        this("default", tableName, columns, pageSize, false, subQuery, params);
    }

    public RawPaginator(String dbName, String tableName, String[] columns, int pageSize, boolean suppressCounts, String subQuery, Object ... params) {
        this.suppressCounts = suppressCounts;
        this.tableName = tableName;
        this.pageSize = pageSize;
        this.subQuery = subQuery;
        this.params = params;
        this.dbName = dbName;
        this.columns = columns;
        try {
            Connection c = new DB(dbName).connection();
            String dbType = c.getMetaData().getDatabaseProductName();
            this.dialect = Registry.instance().getConfiguration().getDialect(dbType);
            this.countQuery = subQuery == null ? this.dialect.selectCount(tableName) : this.dialect.selectCount(tableName, subQuery);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public RawPaginator orderBy(String orderBy) {
        this.orderBys.add(orderBy);
        return this;
    }

    public List<Map> getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("minimum page index == 1");
        }
        String select = this.subQuery == null ? this.dialect.formSelect(this.tableName, this.columns, null, this.orderBys, this.pageSize, (pageNumber - 1) * this.pageSize) : this.dialect.formSelect(this.tableName, this.columns, this.subQuery, this.orderBys, this.pageSize, (pageNumber - 1) * this.pageSize);
        this.currentPage = pageNumber;
        return new DB(this.dbName).findAll(select, this.params);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean getPrevious() {
        return this.hasPrevious();
    }

    public boolean hasPrevious() {
        return this.currentPage > 1 && (long)this.currentPage <= this.pageCount();
    }

    public boolean getNext() {
        return this.hasNext();
    }

    public boolean hasNext() {
        return (long)this.currentPage < this.pageCount();
    }

    public long pageCount() {
        long results = this.getCount();
        long fullPages = results / (long)this.pageSize;
        return results % (long)this.pageSize == 0L ? fullPages : fullPages + 1L;
    }

    public Long getCount() {
        if (this.count == 0L || !this.suppressCounts) {
            this.count = Convert.toLong((Object)new DB(this.dbName).firstCell(this.countQuery, this.params));
            return this.count;
        }
        return this.count;
    }
}

