/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.javalite.common.Util;

enum StatementCache {
    INSTANCE;

    private final ConcurrentMap<Connection, Map<String, PreparedStatement>> statementCache = new ConcurrentHashMap<Connection, Map<String, PreparedStatement>>();

    static StatementCache instance() {
        return INSTANCE;
    }

    PreparedStatement getPreparedStatement(Connection connection, String query) {
        if (!this.statementCache.containsKey(connection)) {
            this.statementCache.put(connection, new HashMap());
        }
        return (PreparedStatement)((Map)this.statementCache.get(connection)).get(query);
    }

    public void cache(Connection connection, String query, PreparedStatement ps) {
        ((Map)this.statementCache.get(connection)).put(query, ps);
    }

    void cleanStatementCache(Connection connection) {
        Map stmsMap = (Map)this.statementCache.remove(connection);
        if (stmsMap != null) {
            for (PreparedStatement stmt : stmsMap.values()) {
                Util.closeQuietly((AutoCloseable)stmt);
            }
        }
    }
}

