/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelListener;
import org.javalite.activejdbc.ModelRegistry;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.conversion.BlankToNullConverter;
import org.javalite.activejdbc.conversion.Converter;
import org.javalite.activejdbc.conversion.ZeroToNullConverter;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.validation.DateConverter;
import org.javalite.activejdbc.validation.EmailValidator;
import org.javalite.activejdbc.validation.NumericValidationBuilder;
import org.javalite.activejdbc.validation.RangeValidator;
import org.javalite.activejdbc.validation.RegexpValidator;
import org.javalite.activejdbc.validation.TimestampConverter;
import org.javalite.activejdbc.validation.ValidationBuilder;
import org.javalite.activejdbc.validation.Validator;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelDelegate.class);
    private static Map<String, Map<String, String>> scopes = new HashMap<String, Map<String, String>>();

    private ModelDelegate() {
    }

    public static List<Association> associations(Class<? extends Model> clazz) {
        return ModelDelegate.metaModelOf(clazz).getAssociations();
    }

    @Deprecated
    public static List<String> attributes(Class<? extends Model> clazz) {
        return Arrays.asList(ModelDelegate.lowerCased(ModelDelegate.attributeNames(clazz)));
    }

    public static Set<String> attributeNames(Class<? extends Model> clazz) {
        return ModelDelegate.metaModelOf(clazz).getAttributeNames();
    }

    public static boolean belongsTo(Class<? extends Model> clazz, Class<? extends Model> targetClass) {
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        return null != metaModel.getAssociationForTarget(targetClass, BelongsToAssociation.class) || null != metaModel.getAssociationForTarget(targetClass, Many2ManyAssociation.class);
    }

    public static void blankToNull(Class<? extends Model> clazz, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).convertWith((Converter)BlankToNullConverter.instance(), attributeNames);
    }

    public static void callbackWith(Class<? extends Model> clazz, CallbackListener ... listeners) {
        ModelDelegate.modelRegistryOf(clazz).callbackWith(listeners);
    }

    @Deprecated
    public static ValidationBuilder convertDate(Class<? extends Model> clazz, String attributeName, String format) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(new DateConverter(attributeName, format));
    }

    @Deprecated
    public static ValidationBuilder convertTimestamp(Class<? extends Model> clazz, String attributeName, String format) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(new TimestampConverter(attributeName, format));
    }

    @Deprecated
    protected static ValidationBuilder convertWith(Class<? extends Model> clazz, org.javalite.activejdbc.validation.Converter converter) {
        return ModelDelegate.validateWith(clazz, converter);
    }

    public static void convertWith(Class<? extends Model> clazz, Converter converter, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).convertWith(converter, attributeNames);
    }

    public static Long count(Class<? extends Model> clazz) {
        Long result;
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        String sql = metaModel.getDialect().selectCount(metaModel.getTableName());
        if (metaModel.cached()) {
            result = (Long)QueryCache.instance().getItem(metaModel.getTableName(), sql, null);
            if (result == null) {
                result = Convert.toLong((Object)new DB(metaModel.getDbName()).firstCell(sql, new Object[0]));
                QueryCache.instance().addItem(metaModel.getTableName(), sql, null, result);
            } else {
                LogFilter.logQuery(LOGGER, sql, new Object[0], System.currentTimeMillis(), true);
            }
        } else {
            result = Convert.toLong((Object)new DB(metaModel.getDbName()).firstCell(sql, new Object[0]));
        }
        return result;
    }

    public static Long count(Class<? extends Model> clazz, String query, Object ... params) {
        Long result;
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        String sql = metaModel.getDialect().selectCount(metaModel.getTableName(), query);
        if (metaModel.cached()) {
            result = (Long)QueryCache.instance().getItem(metaModel.getTableName(), sql, params);
            if (result == null) {
                result = Convert.toLong((Object)new DB(metaModel.getDbName()).firstCell(sql, params));
                QueryCache.instance().addItem(metaModel.getTableName(), sql, params, result);
            }
        } else {
            result = Convert.toLong((Object)new DB(metaModel.getDbName()).firstCell(sql, params));
        }
        return result;
    }

    public static <T extends Model> T create(Class<T> clazz, Object ... namesAndValues) {
        try {
            return ((Model)clazz.newInstance()).set(namesAndValues);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("All even arguments must be strings");
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException("Model '" + clazz.getName() + "' must provide a default constructor.", e);
        }
    }

    public static <T extends Model> T createIt(Class<T> clazz, Object ... namesAndValues) {
        T model = ModelDelegate.create(clazz, namesAndValues);
        ((Model)model).saveIt();
        return model;
    }

    public static void dateFormat(Class<? extends Model> clazz, DateFormat format, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).dateFormat(format, attributeNames);
    }

    public static void dateFormat(Class<? extends Model> clazz, String pattern, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).dateFormat(pattern, attributeNames);
    }

    public static int delete(Class<? extends Model> clazz, String query, Object ... params) {
        int count;
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        int n = count = params == null || params.length == 0 ? new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName() + " WHERE " + query) : new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName() + " WHERE " + query, params);
        if (metaModel.cached()) {
            Registry.cacheManager().purgeTableCache(metaModel);
        }
        ModelDelegate.purgeEdges(metaModel);
        return count;
    }

    public static int deleteAll(Class<? extends Model> clazz) {
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        int count = new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName());
        if (metaModel.cached()) {
            Registry.cacheManager().purgeTableCache(metaModel);
        }
        ModelDelegate.purgeEdges(metaModel);
        return count;
    }

    public static boolean exists(Class<? extends Model> clazz, Object id) {
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        return null != new DB(metaModel.getDbName()).firstCell(metaModel.getDialect().selectExists(metaModel), id);
    }

    public static <T extends Model> LazyList<T> findAll(Class<T> clazz) {
        return new LazyList(null, ModelDelegate.metaModelOf(clazz), new Object[0]);
    }

    public static <T extends Model> T findById(Class<T> clazz, Object id) {
        if (id == null) {
            return null;
        }
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        LazyList list = new LazyList(metaModel.getIdName() + " = ?", metaModel, id).limit(1L);
        return (T)(list.isEmpty() ? null : (Model)list.get(0));
    }

    public static <T extends Model> T findByCompositeKeys(Class<T> clazz, Object ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        String[] compositeKeys = metaModel.getCompositeKeys();
        if (compositeKeys == null || compositeKeys.length != values.length) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < compositeKeys.length; ++i) {
            sb.append(i == 0 ? "" : " AND ").append(compositeKeys[i]).append(" = ?");
        }
        LazyList list = new LazyList(sb.toString(), metaModel, values).limit(1L);
        return (T)(list.isEmpty() ? null : (Model)list.get(0));
    }

    public static <T extends Model> LazyList<T> findBySql(Class<T> clazz, String fullQuery, Object ... params) {
        return new LazyList(false, ModelDelegate.metaModelOf(clazz), fullQuery, params);
    }

    public static <T extends Model> T findFirst(Class<T> clazz, String subQuery, Object ... params) {
        LazyList list = new LazyList(subQuery, ModelDelegate.metaModelOf(clazz), params).limit(1L);
        return (T)(list.isEmpty() ? null : (Model)list.get(0));
    }

    public static <T extends Model, M extends T> void findWith(final Class<M> clazz, final ModelListener<T> listener, String query, Object ... params) {
        long start = System.currentTimeMillis();
        final MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        String sql = metaModel.getDialect().selectStar(metaModel.getTableName(), query);
        new DB(metaModel.getDbName()).find(sql, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                listener.onModel(ModelDelegate.instance(row, metaModel, clazz));
            }
        });
        LogFilter.logQuery(LOGGER, sql, null, start);
    }

    static <T extends Model> T instance(Map<String, Object> map, MetaModel metaModel) {
        return (T)ModelDelegate.instance(map, metaModel, metaModel.getModelClass());
    }

    static <T extends Model> T instance(Map<String, Object> map, MetaModel metaModel, Class<T> clazz) {
        try {
            Model instance = (Model)clazz.newInstance();
            instance.hydrate(map, true);
            return (T)instance;
        }
        catch (InstantiationException e) {
            throw new InitException("Failed to create a new instance of: " + metaModel.getModelClass() + ", are you sure this class has a default constructor?");
        }
        catch (DBException e) {
            throw e;
        }
        catch (InitException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static String[] lowerCased(Collection<String> collection) {
        String[] array = new String[collection.size()];
        int i = 0;
        for (String elem : collection) {
            array[i++] = elem.toLowerCase();
        }
        return array;
    }

    public static MetaModel metaModelFor(String tableName) {
        return Registry.instance().getMetaModel(tableName);
    }

    public static MetaModel metaModelOf(Class<? extends Model> clazz) {
        return Registry.instance().getMetaModel(clazz);
    }

    private static ModelRegistry modelRegistryOf(Class<? extends Model> clazz) {
        return Registry.instance().modelRegistryOf(clazz);
    }

    public static void purgeCache(Class<? extends Model> clazz) {
        MetaModel metaModel = ModelDelegate.metaModelOf(clazz);
        if (metaModel.cached()) {
            Registry.cacheManager().purgeTableCache(metaModel);
        }
    }

    static void purgeEdges(MetaModel metaModel) {
        List<Association> associations = metaModel.getAssociations();
        for (Association association : associations) {
            Registry.cacheManager().purgeTableCache(ModelDelegate.metaModelOf(association.getTargetClass()));
        }
        List<String> edges = Registry.instance().getEdges(metaModel.getTableName());
        for (String edge : edges) {
            Registry.cacheManager().purgeTableCache(edge);
        }
    }

    public static void removeValidator(Class<? extends Model> clazz, Validator validator) {
        ModelDelegate.modelRegistryOf(clazz).removeValidator(validator);
    }

    public static String tableNameOf(Class<? extends Model> clazz) {
        return Registry.instance().getTableName(clazz);
    }

    public static void timestampFormat(Class<? extends Model> clazz, String pattern, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).timestampFormat(pattern, attributeNames);
    }

    public static void timestampFormat(Class<? extends Model> clazz, DateFormat format, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).timestampFormat(format, attributeNames);
    }

    public static int update(Class<? extends Model> clazz, String updates, String conditions, Object ... params) {
        return ModelDelegate.update(ModelDelegate.metaModelOf(clazz), updates, conditions, params);
    }

    private static int update(MetaModel metaModel, String updates, String conditions, Object ... params) {
        Object[] allParams;
        StringBuilder sql = new StringBuilder().append("UPDATE ").append(metaModel.getTableName()).append(" SET ");
        if (metaModel.hasAttribute("updated_at")) {
            sql.append("updated_at = ?, ");
            allParams = new Object[params.length + 1];
            allParams[0] = new Timestamp(System.currentTimeMillis());
            System.arraycopy(params, 0, allParams, 1, params.length);
        } else {
            allParams = params;
        }
        sql.append(updates);
        if (!Util.blank((Object)conditions)) {
            sql.append(" WHERE ").append(conditions);
        }
        int count = new DB(metaModel.getDbName()).exec(sql.toString(), allParams);
        if (metaModel.cached()) {
            Registry.cacheManager().purgeTableCache(metaModel);
        }
        return count;
    }

    public static int updateAll(Class<? extends Model> clazz, String updates, Object ... params) {
        return ModelDelegate.update(clazz, updates, null, params);
    }

    public static ValidationBuilder validateEmailOf(Class<? extends Model> clazz, String attributeName) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(new EmailValidator(attributeName));
    }

    public static NumericValidationBuilder validateNumericalityOf(Class<? extends Model> clazz, String ... attributeNames) {
        return ModelDelegate.modelRegistryOf(clazz).validateNumericalityOf(attributeNames);
    }

    public static List<Validator> validatorsOf(Class<? extends Model> clazz) {
        return ModelDelegate.modelRegistryOf(clazz).validators();
    }

    public static ValidationBuilder validatePresenceOf(Class<? extends Model> clazz, String ... attributeNames) {
        return ModelDelegate.modelRegistryOf(clazz).validatePresenceOf(attributeNames);
    }

    public static ValidationBuilder validateRange(Class<? extends Model> clazz, String attributeName, Number min, Number max) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(new RangeValidator(attributeName, min, max));
    }

    public static ValidationBuilder validateRegexpOf(Class<? extends Model> clazz, String attributeName, String pattern) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(new RegexpValidator(attributeName, pattern));
    }

    public static ValidationBuilder validateWith(Class<? extends Model> clazz, Validator validator) {
        return ModelDelegate.modelRegistryOf(clazz).validateWith(validator);
    }

    public static <T extends Model> LazyList<T> where(Class<T> clazz, String subquery, Object ... params) {
        if (subquery.trim().equals("*")) {
            if (Util.empty((Object[])params)) {
                return ModelDelegate.findAll(clazz);
            }
            throw new IllegalArgumentException("cannot provide parameters with query: '*', use findAll() method instead");
        }
        return new LazyList(subquery, ModelDelegate.metaModelOf(clazz), params);
    }

    public static void zeroToNull(Class<? extends Model> clazz, String ... attributeNames) {
        ModelDelegate.modelRegistryOf(clazz).convertWith((Converter)ZeroToNullConverter.instance(), attributeNames);
    }

    public static <T extends Model> T findOrInit(Class<T> clazz, Object ... namesAndValues) {
        return ModelDelegate.findOrCreateIt(clazz, false, namesAndValues);
    }

    public static <T extends Model> T findOrCreateIt(Class<T> clazz, Object ... namesAndValues) {
        return ModelDelegate.findOrCreateIt(clazz, true, namesAndValues);
    }

    public static <T extends Model> T findOrCreateIt(Class<T> clazz, boolean save, Object ... namesAndValues) {
        if (namesAndValues.length == 0 || namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        StringBuilder subQuery = new StringBuilder();
        Object[] params = new Object[namesAndValues.length / 2];
        int x = 0;
        for (int i = 0; i < namesAndValues.length; ++i) {
            if (i % 2 == 0) {
                subQuery.append(subQuery.length() > 0 ? " and " + namesAndValues[i] + " = ?" : namesAndValues[i] + " = ?");
                continue;
            }
            params[x++] = namesAndValues[i];
        }
        T instance = ModelDelegate.findFirst(clazz, subQuery.toString(), params);
        if (instance != null) {
            return instance;
        }
        if (save) {
            return ModelDelegate.createIt(clazz, namesAndValues);
        }
        try {
            Model m = (Model)clazz.newInstance();
            m.set(namesAndValues);
            return (T)m;
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    public static void addScope(String className, String scope, String criteria) {
        if (!scopes.containsKey(className)) {
            scopes.put(className, new HashMap());
        }
        scopes.get(className).put(scope, criteria);
    }

    static Map<String, String> getScopes(String className) {
        if (!scopes.containsKey(className)) {
            scopes.put(className, new HashMap());
        }
        return scopes.get(className);
    }
}

