/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.associations;

import java.util.Map;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.Model;

public class Many2ManyAssociation
extends Association {
    public static final String SOURCE_FK = "sourceFK";
    public static final String TARGET_FK = "targetFK";
    public static final String JOIN = "join";
    public static final String TARGET_PK = "targetPK";
    private String sourceFkName;
    private String targetFkName;
    private String join;
    private String targetPk;

    public Many2ManyAssociation(Map<String, Object> map) throws ClassNotFoundException {
        super(map);
        this.sourceFkName = (String)map.get(SOURCE_FK);
        this.targetFkName = (String)map.get(TARGET_FK);
        this.join = (String)map.get(JOIN);
        this.targetPk = (String)map.get(TARGET_PK);
    }

    public Many2ManyAssociation(Class<? extends Model> source, Class<? extends Model> target, String join, String sourceFkName, String targetFkName, String targetPk) {
        super(source, target);
        this.targetFkName = targetFkName;
        this.sourceFkName = sourceFkName;
        this.join = join;
        this.targetPk = targetPk;
    }

    public Many2ManyAssociation(Class<? extends Model> sourceModelClass, Class<? extends Model> targetModelClass, String join, String sourceFkName, String targetFkName) {
        this(sourceModelClass, targetModelClass, join, sourceFkName, targetFkName, "id");
    }

    public String getSourceFkName() {
        return this.sourceFkName;
    }

    public String getTargetFkName() {
        return this.targetFkName;
    }

    public String getJoin() {
        return this.join;
    }

    public String getTargetPk() {
        return this.targetPk;
    }

    public String toString() {
        return this.getSourceClass().getSimpleName() + "  >---------<  " + this.getTargetClass().getSimpleName() + ", type: many-to-many, join: " + this.join;
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        Many2ManyAssociation otherAss = (Many2ManyAssociation)other;
        return otherAss.getSourceClass().equals(this.getSourceClass()) && otherAss.getTargetClass().equals(this.getTargetClass()) && otherAss.getSourceFkName().equalsIgnoreCase(this.getSourceFkName()) && otherAss.getTargetFkName().equalsIgnoreCase(this.getTargetFkName()) && otherAss.getJoin().equalsIgnoreCase(this.getJoin());
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put(SOURCE_FK, this.sourceFkName);
        map.put(TARGET_FK, this.targetFkName);
        map.put(JOIN, this.join);
        map.put(TARGET_PK, this.targetPk);
        return map;
    }
}

