/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheEventListener;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManager.class);
    List<CacheEventListener> listeners = new ArrayList<CacheEventListener>();

    public abstract Object getCache(String var1, String var2);

    public abstract void addCache(String var1, String var2, Object var3);

    public abstract void doFlush(CacheEvent var1);

    public final void flush(CacheEvent event, boolean propagate) {
        this.doFlush(event);
        if (propagate) {
            this.propagate(event);
        }
        String message = "Cache purged: " + (event.getType() == CacheEvent.CacheEventType.ALL ? "all caches" : "table: " + event.getGroup());
        LogFilter.log(LOGGER, LogLevel.DEBUG, message);
    }

    private void propagate(CacheEvent event) {
        for (CacheEventListener listener : this.listeners) {
            try {
                listener.onFlush(event);
            }
            catch (Exception e) {
                LOGGER.debug("failed to propagate cache event: {} to listener: {}", new Object[]{event, listener, e});
            }
        }
    }

    public final void flush(CacheEvent event) {
        this.flush(event, true);
    }

    public final void addCacheEventListener(CacheEventListener listener) {
        this.listeners.add(listener);
    }

    public final void removeCacheEventListener(CacheEventListener listener) {
        this.listeners.remove(listener);
    }

    public final void removeAllCacheEventListeners() {
        this.listeners = new ArrayList<CacheEventListener>();
    }

    public void purgeTableCache(MetaModel metaModel) {
        this.flush(new CacheEvent(metaModel.getTableName(), this.getClass().getName()));
    }

    public void purgeTableCache(String tableName) {
        this.flush(new CacheEvent(tableName, this.getClass().getName()));
    }

    public String getKey(String tableName, String query, Object[] params) {
        return tableName + query + (params == null ? null : Arrays.asList(params).toString());
    }

    public abstract Object getImplementation();
}

