/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.ModelRegistry;
import org.javalite.activejdbc.associations.Association;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Collections;
import org.javalite.common.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaModels {
    private static final String DB_NAME = "dbName";
    private static final String DB_TYPE = "dbType";
    private static final String MODEL_CLASS = "modelClass";
    private static final String COLUMN_METADATA = "columnMetadata";
    private static final String COLUMN_METADATA_NAME = "columnName";
    private static final String COLUMN_METADATA_TYPE = "typeName";
    private static final String COLUMN_METADATA_SIZE = "columnSize";
    private static final String ASSOCIATIONS = "associations";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaModels.class);
    private final Map<String, MetaModel> metaModelsByTableName = new CaseInsensitiveMap();
    private final Map<String, MetaModel> metaModelsByClassName = new HashMap<String, MetaModel>();
    private final List<Many2ManyAssociation> many2ManyAssociations = new ArrayList<Many2ManyAssociation>();
    private final Map<Class, ModelRegistry> modelRegistries = new HashMap<Class, ModelRegistry>();

    MetaModels() {
    }

    void addMetaModel(MetaModel mm, Class<? extends Model> modelClass) {
        MetaModel o = this.metaModelsByClassName.put(modelClass.getName(), mm);
        if (o != null) {
            LogFilter.log(LOGGER, LogLevel.WARNING, "Double-register: {}: {}", modelClass, (Object)o);
        }
        o = this.metaModelsByTableName.put(mm.getTableName(), mm);
        this.many2ManyAssociations.addAll(mm.getManyToManyAssociations(new Association[0]));
        if (o != null) {
            LogFilter.log(LOGGER, LogLevel.WARNING, "Double-register: {}: {}", (Object)mm.getTableName(), (Object)o);
        }
    }

    ModelRegistry getModelRegistry(Class<? extends Model> modelClass) {
        return this.modelRegistries.computeIfAbsent(modelClass, k -> new ModelRegistry());
    }

    MetaModel getMetaModel(Class<? extends Model> modelClass) {
        return this.metaModelsByClassName.get(modelClass.getName());
    }

    MetaModel getMetaModel(String tableName) {
        return this.metaModelsByTableName.get(tableName);
    }

    String[] getTableNames(String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (MetaModel metaModel : this.metaModelsByTableName.values()) {
            if (!metaModel.getDbName().equals(dbName)) continue;
            tableNames.add(metaModel.getTableName());
        }
        return tableNames.toArray(new String[tableNames.size()]);
    }

    Class<? extends Model> getModelClass(String tableName) {
        MetaModel mm = this.metaModelsByTableName.get(tableName);
        return mm == null ? null : mm.getModelClass();
    }

    String getTableName(Class<? extends Model> modelClass) {
        return this.metaModelsByClassName.containsKey(modelClass.getName()) ? this.metaModelsByClassName.get(modelClass.getName()).getTableName() : null;
    }

    public void setColumnMetadata(String table, Map<String, ColumnMetadata> metaParams) {
        this.metaModelsByTableName.get(table).setColumnMetadata(metaParams);
    }

    protected List<String> getEdges(String join) {
        ArrayList<String> results = new ArrayList<String>();
        for (Many2ManyAssociation a : this.many2ManyAssociations) {
            if (!a.getJoin().equalsIgnoreCase(join)) continue;
            results.add(this.getMetaModel(a.getSourceClass()).getTableName());
            results.add(this.getMetaModel(a.getTargetClass()).getTableName());
        }
        return results;
    }

    protected String toJSON() {
        ArrayList models = new ArrayList();
        this.metaModelsByTableName.values().forEach(metaModel -> {
            ArrayList associations = new ArrayList();
            metaModel.getAssociations().forEach(association -> associations.add(association.toMap()));
            models.add(Collections.map((Object[])new Object[]{MODEL_CLASS, metaModel.getModelClass().getName(), DB_TYPE, metaModel.getDbType(), DB_NAME, metaModel.getDbName(), COLUMN_METADATA, metaModel.getColumnMetadata(), ASSOCIATIONS, associations}));
        });
        return JsonHelper.toJsonString(models, (boolean)false);
    }

    protected void fromJSON(String json) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(Void.TYPE, Map.class);
            for (Object o : JsonHelper.toList((String)json)) {
                Map metaModelMap = (Map)o;
                MetaModel metaModel = new MetaModel((String)metaModelMap.get(DB_NAME), Class.forName((String)metaModelMap.get(MODEL_CLASS)), (String)metaModelMap.get(DB_TYPE));
                CaseInsensitiveMap columnMetadataMap = new CaseInsensitiveMap();
                metaModelMap.getOrDefault(COLUMN_METADATA, Collections.map((Object[])new Object[0])).forEach((arg_0, arg_1) -> MetaModels.lambda$fromJSON$3((Map)columnMetadataMap, arg_0, arg_1));
                metaModel.setColumnMetadata((Map<String, ColumnMetadata>)columnMetadataMap);
                for (Object a : metaModelMap.getOrDefault(ASSOCIATIONS, java.util.Collections.emptyList())) {
                    Map map = (Map)a;
                    metaModel.addAssociation(lookup.findConstructor(Class.forName((String)map.get("class")), methodType).invoke(map));
                }
                this.addMetaModel(metaModel, metaModel.getModelClass());
            }
        }
        catch (Throwable e) {
            throw new InitException("Cannot load metadata", e);
        }
    }

    private static /* synthetic */ void lambda$fromJSON$3(Map columnMetadataMap, Object column, Object map) {
        Map metadata = (Map)map;
        columnMetadataMap.put((String)column, new ColumnMetadata((String)metadata.get(COLUMN_METADATA_NAME), (String)metadata.get(COLUMN_METADATA_TYPE), (Integer)metadata.get(COLUMN_METADATA_SIZE)));
    }
}

