/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.util.Map;
import org.javalite.activejdbc.dialects.DB2Dialect;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.activejdbc.dialects.H2Dialect;
import org.javalite.activejdbc.dialects.MSSQLDialect;
import org.javalite.activejdbc.dialects.MySQLDialect;
import org.javalite.activejdbc.dialects.OracleDialect;
import org.javalite.activejdbc.dialects.PostgreSQLDialect;
import org.javalite.activejdbc.dialects.SQLiteDialect;
import org.javalite.common.CaseInsensitiveMap;

public class Dialects {
    private static final Map<String, Dialect> dialects = new CaseInsensitiveMap();

    public static Dialect getDialect(String dbType) {
        Dialect dialect = dialects.get(dbType);
        if (dialect == null) {
            dialect = dbType.equalsIgnoreCase("Oracle") ? new OracleDialect() : (dbType.startsWith("DB2") ? new DB2Dialect() : (dbType.equalsIgnoreCase("MySQL") ? new MySQLDialect() : (dbType.equalsIgnoreCase("MariaDB") ? new MySQLDialect() : (dbType.equalsIgnoreCase("PostgreSQL") ? new PostgreSQLDialect() : (dbType.equalsIgnoreCase("h2") ? new H2Dialect() : (dbType.equalsIgnoreCase("Microsoft SQL Server") ? new MSSQLDialect() : (dbType.equalsIgnoreCase("SQLite") ? new SQLiteDialect() : new DefaultDialect())))))));
            dialects.put(dbType, dialect);
        }
        return dialect;
    }
}

