/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.util.ArrayList;
import java.util.List;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.DefaultDialect;

public class DB2Dialect
extends DefaultDialect {
    private final List<String> EMPTY_LIST = new ArrayList<String>();

    @Override
    public String formSelect(String tableName, String[] columns, String subQuery, List<String> orderBys, long limit, long offset) {
        boolean needOffset = offset != -1L;
        boolean needLimit = limit != -1L;
        StringBuilder fullQuery = new StringBuilder(subQuery == null ? 0 : subQuery.length());
        if (needOffset) {
            StringBuilder innerQuery = new StringBuilder(subQuery == null ? 0 : subQuery.length());
            this.appendSelect(innerQuery, tableName, columns, null, subQuery, this.EMPTY_LIST);
            fullQuery.append("SELECT * FROM (SELECT ROW_NUMBER() OVER(");
            this.appendOrderBy(fullQuery, orderBys);
            fullQuery.append(") AS ROWNUMBER, ORIG.* from (");
            fullQuery.append(innerQuery.toString());
            fullQuery.append(") as ORIG) as TEMP WHERE TEMP.ROWNUMBER ");
            if (needLimit) {
                fullQuery.append(" BETWEEN ");
                fullQuery.append(offset + 1L);
                fullQuery.append(" AND ");
                fullQuery.append(offset + limit);
            } else {
                fullQuery.append(" > ");
                fullQuery.append(offset);
            }
        } else {
            this.appendSelect(fullQuery, tableName, columns, null, subQuery, orderBys);
            if (needLimit) {
                fullQuery.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY");
            }
        }
        return fullQuery.toString();
    }

    @Override
    protected void appendEmptyRow(MetaModel metaModel, StringBuilder query) {
        query.append('(').append(metaModel.getIdName()).append(") VALUES (DEFAULT)");
    }
}

