/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javalite.activeweb.AWMockMultipartHttpServletRequest;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.ControllerRunner;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.FormItem;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.MockMultipartHttpServletRequestImpl;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.SessionTestFacade;
import org.javalite.activeweb.SpecException;
import org.javalite.activeweb.WebException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RequestBuilder {
    private static final String MULTIPART = "multipart/form-data";
    private boolean integrateViews = false;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, String> headers = new HashMap<String, String>();
    private String contentType;
    private byte[] content;
    private String controllerPath;
    private SessionTestFacade sessionFacade;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private MockHttpServletRequest request;
    private String realAction;
    private List<FormItem> formItems = new ArrayList<FormItem>();
    private String id;
    private String queryString;

    public RequestBuilder(String controllerPath, SessionTestFacade sessionFacade) {
        this.controllerPath = controllerPath;
        this.sessionFacade = sessionFacade;
    }

    public RequestBuilder formItem(String name, String fieldName, boolean isFile, String contentType, byte[] content) {
        this.checkContentType();
        this.formItems.add(new FormItem(name, fieldName, isFile, contentType, content));
        return this;
    }

    public RequestBuilder formItem(FormItem item) {
        this.checkContentType();
        this.formItems.add(item);
        return this;
    }

    private void checkContentType() {
        if (this.contentType == null || !this.contentType.equals(MULTIPART)) {
            throw new IllegalArgumentException("Must set content type to: 'multipart/form-data' before adding a new form item");
        }
    }

    private void checkParamAndMultipart() {
        if (this.contentType != null && this.contentType.equals(MULTIPART) && this.values.size() > 0) {
            throw new IllegalArgumentException("cannot use param() with content type: multipart/form-data, use formItem()");
        }
    }

    public RequestBuilder param(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("neither argument can be null");
        }
        if (value instanceof List) {
            List list = (List)value;
            this.values.put(name, list);
        } else {
            this.values.put(name, value.toString());
        }
        return this;
    }

    public RequestBuilder param(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.values.put(name, "");
        return this;
    }

    public RequestBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder headers(String ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null || namesAndValues[i + 1] == null) {
                throw new IllegalArgumentException("header names or values cannot be null");
            }
            this.header(namesAndValues[i], namesAndValues[i + 1]);
        }
        return this;
    }

    public RequestBuilder params(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("parameter names cannot be nulls");
            }
            this.param(namesAndValues[i].toString(), namesAndValues[i + 1]);
        }
        return this;
    }

    public RequestBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestBuilder cookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public RequestBuilder content(byte[] content) {
        this.content = content;
        return this;
    }

    public RequestBuilder integrateViews() {
        this.integrateViews(true);
        return this;
    }

    public RequestBuilder integrateViews(boolean integrateViews) {
        this.integrateViews = integrateViews;
        return this;
    }

    public void get(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.GET);
    }

    public void post(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.POST);
    }

    public void put(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.PUT);
    }

    public void delete(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.DELETE);
    }

    private void submitRequest(String actionName, HttpMethod method) {
        String path;
        this.checkParamAndMultipart();
        if (this.contentType != null && this.contentType.equals(MULTIPART) && this.formItems.size() > 0) {
            this.request = new MockMultipartHttpServletRequestImpl();
            for (FormItem item : this.formItems) {
                ((AWMockMultipartHttpServletRequest)this.request).addFormItem(item);
            }
        } else {
            this.request = new MockHttpServletRequest();
        }
        this.request.setContextPath("/test_context");
        Context.setHttpRequest((HttpServletRequest)this.request);
        if (this.sessionFacade != null) {
            this.request.setSession(this.sessionFacade.getSession());
        }
        if (this.contentType != null) {
            this.request.setContentType(this.contentType);
        }
        if (this.content != null) {
            this.request.setContent(this.content);
        }
        if (!(path = this.controllerPath + (this.realAction != null ? "/" + this.realAction : "")).startsWith("/")) {
            path = "/" + path;
        }
        this.request.setServletPath(path);
        this.request.setRequestURI(path);
        this.request.setAttribute("id", (Object)this.id);
        this.request.setQueryString(this.queryString);
        this.addCookiesInternal(this.request);
        if (!method.equals((Object)HttpMethod.GET) && !method.equals((Object)HttpMethod.POST)) {
            this.request.setParameter("_method", method.toString());
            this.request.setMethod("POST");
        } else {
            this.request.setMethod(method.toString());
        }
        Context.getRequestContext().set("integrateViews", (Object)this.integrateViews);
        this.addHeaders(this.request);
        this.addParameterValues(this.request);
        try {
            AppController controller = ControllerFactory.createControllerInstance((String)ControllerFactory.getControllerClassName((String)this.controllerPath));
            Context.setRoute((Route)new Route(controller, this.realAction, this.id));
            Injector injector = Context.getControllerRegistry().getInjector();
            long start = System.currentTimeMillis();
            if (injector != null) {
                injector.injectMembers((Object)controller);
            }
            ControllerRunner runner = new ControllerRunner();
            Context.setControllerResponse(null);
            Context.setHttpResponse((HttpServletResponse)new MockHttpServletResponse());
            Context.setActionName((String)actionName);
            runner.run(new Route(controller, actionName), this.integrateViews);
        }
        catch (WebException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecException(e);
        }
    }

    private void addHeaders(MockHttpServletRequest request) {
        for (String header : this.headers.keySet()) {
            request.addHeader(header, (Object)this.headers.get(header));
        }
    }

    private void addCookiesInternal(MockHttpServletRequest request) {
        ArrayList<javax.servlet.http.Cookie> servletCookieList = new ArrayList<javax.servlet.http.Cookie>();
        for (Cookie cookie : this.cookies) {
            servletCookieList.add(Cookie.toServletCookie((Cookie)cookie));
        }
        javax.servlet.http.Cookie[] arr = servletCookieList.toArray(new javax.servlet.http.Cookie[0]);
        request.setCookies(arr);
    }

    private void addParameterValues(MockHttpServletRequest httpServletRequest) {
        for (String key : this.values.keySet()) {
            Object value = this.values.get(key);
            if (value instanceof List) {
                ArrayList<String> strings = new ArrayList<String>(((List)value).size());
                for (Object v : (List)value) {
                    strings.add(v.toString());
                }
                httpServletRequest.addParameter(key, strings.toArray(new String[0]));
                continue;
            }
            httpServletRequest.addParameter(key, value.toString());
        }
    }

    public RequestBuilder id(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null");
        }
        this.id = id.toString();
        return this;
    }

    public RequestBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }
}

