/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.DBSpecHelper;
import org.javalite.activeweb.IntegrationSpec;
import org.javalite.activeweb.RequestBuilder;
import org.javalite.activeweb.RequestDispatcher;
import org.junit.After;
import org.junit.Before;
import org.springframework.mock.web.MockFilterConfig;

public abstract class AppIntegrationSpec
extends IntegrationSpec {
    private boolean suppressDb;
    private AppContext context;
    private RequestDispatcher requestDispatcher = new RequestDispatcher();

    @Before
    public void beforeAppIntegrationSpec() throws ServletException {
        this.requestDispatcher.init((FilterConfig)new MockFilterConfig());
        this.context = this.requestDispatcher.getContext();
        if (!this.suppressDb) {
            DBSpecHelper.openTestConnections();
        }
    }

    @After
    public void afterAppIntegrationSpec() {
        if (!this.suppressDb) {
            DBSpecHelper.closeTestConnections();
            DBSpecHelper.clearConnectionWrappers();
        }
        this.requestDispatcher.destroy();
    }

    public AppContext getContext() {
        return this.context;
    }

    @Override
    protected RequestBuilder controller(String controllerPath) {
        RequestBuilder requestBuilder = new RequestBuilder(controllerPath, this.session(), false);
        requestBuilder.integrateViews();
        return requestBuilder;
    }

    protected void suppressDb() {
        this.suppressDb = true;
    }
}

