/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.LinkedList;
import java.util.List;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSpecHelper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)DBSpecHelper.class.getSimpleName());

    private DBSpecHelper() {
    }

    public static void initDBConfig() {
        String dbConfigClassName = Configuration.get((String)"dbconfig");
        try {
            Object dbconfig = Class.forName(dbConfigClassName).newInstance();
            dbconfig.getClass().getMethod("init", AppContext.class).invoke(dbconfig, new AppContext());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Failed to locate class: " + dbConfigClassName + ", proceeding without it...");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize class " + dbConfigClassName + " are you sure you defined this class?", e);
        }
    }

    public static void clearConnectionWrappers() {
        Configuration.clearConnectionWrappers();
    }

    public static void openTestConnections() {
        List<ConnectionSpecWrapper> connectionWrappers = DBSpecHelper.getTestConnectionWrappers();
        if (connectionWrappers.isEmpty()) {
            LOGGER.warn("no DB connections are configured, none opened");
            return;
        }
        for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
            DB db = new DB(connectionWrapper.getDbName());
            db.open(connectionWrapper.getConnectionSpec());
            if (!Configuration.rollback()) continue;
            db.openTransaction();
        }
    }

    public static void closeTestConnections() {
        List<ConnectionSpecWrapper> connectionWrappers = DBSpecHelper.getTestConnectionWrappers();
        for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
            String dbName = connectionWrapper.getDbName();
            DB db = new DB(dbName);
            if (Configuration.rollback()) {
                db.rollbackTransaction();
            }
            db.close();
        }
    }

    private static List<ConnectionSpecWrapper> getTestConnectionWrappers() {
        List allConnections = Configuration.getConnectionSpecWrappers();
        LinkedList<ConnectionSpecWrapper> result = new LinkedList<ConnectionSpecWrapper>();
        for (ConnectionSpecWrapper connectionWrapper : allConnections) {
            if (!connectionWrapper.isTesting()) continue;
            result.add(connectionWrapper);
        }
        return result;
    }
}

