/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerRegistry;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.SessionTestFacade;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.FreeMarkerTemplateManager;
import org.javalite.common.Convert;
import org.javalite.test.jspec.JSpecSupport;
import org.junit.After;
import org.junit.Before;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;

public class SpecHelper
extends JSpecSupport {
    private SessionTestFacade sessionFacade;

    @Before
    public void atStart() {
        this.sessionFacade = new SessionTestFacade((HttpSession)new MockHttpSession());
        this.setTemplateLocation("src/main/webapp/WEB-INF/views");
        Context.setTLs(null, (HttpServletResponse)new MockHttpServletResponse(), (FilterConfig)new MockFilterConfig(), (ControllerRegistry)new ControllerRegistry((FilterConfig)new MockFilterConfig()), (AppContext)new AppContext(), (RequestContext)new RequestContext(), null);
    }

    @After
    public void afterEnd() {
        Context.clear();
    }

    protected void setTemplateLocation(String location) {
        Configuration.getTemplateManager().setTemplateLocation(location);
    }

    protected void setInjector(Injector injector) {
        Context.getControllerRegistry().setInjector(injector);
    }

    protected <T extends AbstractModule> ModuleBuilder createInjector(T module) {
        return new ModuleBuilder((Module)module);
    }

    protected void registerTag(String name, FreeMarkerTag tag) {
        ((FreeMarkerTemplateManager)Configuration.getTemplateManager()).registerTag(name, tag);
    }

    protected SessionTestFacade session() {
        return this.sessionFacade;
    }

    protected Object flash(String name) {
        if (this.session().get("flasher") == null) {
            return null;
        }
        Map flasher = (Map)this.session().get("flasher");
        return flasher.get(name) == null ? null : flasher.get(name);
    }

    protected Object flashExists(String name) {
        Map flasher = (Map)this.session().get("flasher");
        return flasher != null && flasher.containsKey(name);
    }

    protected <T> T flash(String name, Class<T> type) {
        return (T)this.flash(name);
    }

    protected void session(String name, Serializable value) {
        this.session().put(name, value);
    }

    protected Object sessionObject(String name) {
        return this.session().get(name);
    }

    protected String sessionString(String name) {
        return (String)this.session().get(name);
    }

    protected Integer sessionInteger(String name) {
        return Convert.toInteger((Object)this.session().get(name));
    }

    protected <T> T session(String name, Class<T> type) {
        return (T)this.session().get(name);
    }

    protected Boolean sessionBoolean(String name) {
        return Convert.toBoolean((Object)this.session().get(name));
    }

    protected Double sessionDouble(String name) {
        return Convert.toDouble((Object)this.session().get(name));
    }

    protected Float sessionFloat(String name) {
        return Convert.toFloat((Object)this.session().get(name));
    }

    protected Long sessionLong(String name) {
        return Convert.toLong((Object)this.session().get(name));
    }

    protected boolean sessionHas(String name) {
        return this.session().get(name) != null;
    }

    public class ModuleBuilder {
        private List<Class> interfaceClasses = new ArrayList<Class>();
        private List<Class> mockClasses = new ArrayList<Class>();
        private Module module;

        protected ModuleBuilder(Module module) {
            this.module = module;
        }

        public ModuleBuilder override(Class interfaceClass) {
            this.interfaceClasses.add(interfaceClass);
            return this;
        }

        public ModuleBuilder with(Class mockClass) {
            this.mockClasses.add(mockClass);
            return this;
        }

        public Injector create() {
            ArrayList<MockModule> modules = new ArrayList<MockModule>();
            for (int i = 0; i < this.interfaceClasses.size(); ++i) {
                modules.add(new MockModule(this.interfaceClasses.get(i), this.mockClasses.get(i)));
            }
            return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{this.module}).with(modules)});
        }

        private class MockModule
        extends AbstractModule {
            private Class interfaceClass;
            private Class mockClass;

            private MockModule(Class interfaceClass, Class mockClass) {
                this.interfaceClass = interfaceClass;
                this.mockClass = mockClass;
            }

            protected void configure() {
                this.bind(this.interfaceClass).to(this.mockClass).asEagerSingleton();
            }
        }
    }
}

