/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerRegistry;
import org.javalite.activeweb.ParamCopy;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.SpecHelper;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.freemarker.ContentTL;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.FreeMarkerTemplateManager;
import org.javalite.common.Collections;
import org.junit.After;
import org.junit.Before;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewSpec
extends SpecHelper {
    private FreeMarkerTemplateManager manager = new FreeMarkerTemplateManager();

    public ViewSpec() {
        this.manager.setTemplateLocation("src/main/webapp/WEB-INF/views");
    }

    @Before
    public final void beforeTest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/test_context");
        Context.setTLs((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse(), (FilterConfig)new MockFilterConfig(), (ControllerRegistry)new ControllerRegistry((FilterConfig)new MockFilterConfig()), (AppContext)new AppContext(), (RequestContext)new RequestContext());
    }

    @After
    public final void afterTest() {
        Context.clear();
    }

    @Override
    public void setTemplateLocation(String templateLocation) {
        this.manager.setTemplateLocation(templateLocation);
    }

    @Override
    protected void setInjector(Injector injector) {
        Context.getControllerRegistry().setInjector(injector);
    }

    @Override
    protected void registerTag(String name, FreeMarkerTag tag) {
        this.manager.registerTag(name, tag);
        Injector injector = Context.getControllerRegistry().getInjector();
        if (injector != null) {
            injector.injectMembers((Object)tag);
        }
    }

    protected String render(String templateName) {
        return this.render(templateName, new HashMap());
    }

    protected String render(String templateName, Map values) {
        StringWriter stringWriter = new StringWriter();
        ParamCopy.copyInto((Map)values);
        this.manager.merge(values, templateName, (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected String render(String templateName, String ... namesAndValues) {
        return this.render(templateName, Collections.map((Object[])namesAndValues));
    }

    protected <T extends AppController> void setCurrentController(Class<T> controllerClass) {
        try {
            AppController instance = (AppController)controllerClass.newInstance();
            Context.setRestful((Boolean)instance.restful());
            Context.setControllerPath((String)Router.getControllerPath(controllerClass));
        }
        catch (Exception e) {
            throw new ViewException((Throwable)e);
        }
    }

    protected List<String> contentFor(String name) {
        return (List)ContentTL.getAllContent().get(name);
    }
}

