/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.DBSpecHelper;
import org.javalite.activeweb.IntegrationSpec;
import org.javalite.activeweb.RequestBuilder;
import org.javalite.activeweb.RequestDispatcher;
import org.junit.After;
import org.junit.Before;
import org.springframework.mock.web.MockFilterConfig;

public abstract class AppIntegrationSpec
extends IntegrationSpec {
    private boolean suppressDb = false;
    private AppContext context = new AppContext();
    private RequestDispatcher requestDispatcher = new RequestDispatcher();

    @Before
    public void beforeAppIntegrationSpec() throws ServletException {
        this.requestDispatcher.init((FilterConfig)new MockFilterConfig());
        this.requestDispatcher.initApp(this.context);
        if (!this.suppressDb) {
            Configuration.setTesting((boolean)true);
            DBSpecHelper.openTestConnections();
        }
    }

    @After
    public void afterAppIntegrationSpec() {
        if (!this.suppressDb) {
            DBSpecHelper.closeTestConnections();
            DBSpecHelper.clearConnectionWrappers();
        }
    }

    public AppContext getContext() {
        return this.context;
    }

    protected RequestBuilder controller(String controllerPath) {
        RequestBuilder requestBuilder = new RequestBuilder(controllerPath, this.session());
        requestBuilder.integrateViews();
        return requestBuilder;
    }

    protected void suppressDb() {
        this.suppressDb = true;
    }
}

