/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.Map;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerResponse;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.RedirectResponse;
import org.javalite.activeweb.RenderTemplateResponse;
import org.javalite.activeweb.SpecException;
import org.javalite.activeweb.SpecHelper;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.javalite.test.jspec.TestException;
import org.springframework.mock.web.MockHttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSpecHelper
extends SpecHelper {
    protected int statusCode() {
        return Context.getControllerResponse().getStatus();
    }

    protected String contentType() {
        return Context.getControllerResponse().getContentType();
    }

    protected String responseContent() {
        try {
            Boolean integrateViews = (Boolean)Context.getRequestContext().get("integrateViews");
            String content = ((MockHttpServletResponse)Context.getHttpResponse()).getContentAsString();
            if (!integrateViews.booleanValue() && Util.blank((Object)content)) {
                throw new SpecException("Use integrateViews() method to generate response content");
            }
            return content;
        }
        catch (SpecException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecException(e);
        }
    }

    protected byte[] bytesContent() {
        try {
            return ((MockHttpServletResponse)Context.getHttpResponse()).getContentAsByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String layout() {
        ControllerResponse resp = Context.getControllerResponse();
        try {
            if (!(resp instanceof RenderTemplateResponse)) {
                throw new SpecException("failed to get layout, did you perform a render operation? I found a different  response: " + resp.getClass());
            }
            return ((RenderTemplateResponse)resp).getLayout();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected String template() {
        ControllerResponse resp = Context.getControllerResponse();
        try {
            if (!(resp instanceof RenderTemplateResponse)) {
                throw new SpecException("failed to get layout, did you perform a render operation? I found a different  response: " + resp.getClass());
            }
            return ((RenderTemplateResponse)resp).getTemplate();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected Map assigns() {
        if (Context.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return Context.getControllerResponse().values();
    }

    protected Map vals() {
        if (Context.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return Context.getControllerResponse().values();
    }

    protected Object val(String name) {
        if (Context.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        Object val = Context.getControllerResponse().values().get(name);
        return val == null ? Context.getHttpRequest().getAttribute(name) : val;
    }

    protected <T> T val(String name, Class<T> type) {
        if (Context.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return (T)Context.getControllerResponse().values().get(name);
    }

    protected String valString(String name) {
        assert (name != null);
        return this.val(name).toString();
    }

    protected int valInteger(String name) {
        assert (name != null);
        return Convert.toInteger((Object)this.val(name));
    }

    protected long valLong(String name) {
        assert (name != null);
        return Convert.toLong((Object)this.val(name));
    }

    protected double valDouble(String name) {
        assert (name != null);
        return Convert.toDouble((Object)this.val(name));
    }

    protected float valFloat(String name) {
        assert (name != null);
        return Convert.toFloat((Object)this.val(name)).floatValue();
    }

    protected boolean valBoolean(String name) {
        assert (name != null);
        return Convert.toBoolean((Object)this.val(name));
    }

    protected boolean redirected() {
        return Context.getControllerResponse() instanceof RedirectResponse;
    }

    protected String redirectValue() {
        ControllerResponse resp = Context.getControllerResponse();
        if (resp != null && resp instanceof RedirectResponse) {
            RedirectResponse redirectResponse = (RedirectResponse)resp;
            return redirectResponse.redirectValue();
        }
        return null;
    }

    protected Cookie[] getCookies() {
        if (Context.getHttpResponse() == null) {
            throw new IllegalStateException("response does not exist");
        }
        javax.servlet.http.Cookie[] servletCookies = ((MockHttpServletResponse)Context.getHttpResponse()).getCookies();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (javax.servlet.http.Cookie cookie : servletCookies) {
            cookies.add(Cookie.fromServletCookie((javax.servlet.http.Cookie)cookie));
        }
        return cookies.toArray(new Cookie[0]);
    }

    protected Cookie cookie(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = this.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    protected String cookieValue(String name) {
        return this.cookie(name).getValue();
    }
}

