/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ControllerResponse;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.RedirectResponse;
import org.javalite.activeweb.RenderTemplateResponse;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.SpecException;
import org.javalite.activeweb.SpecHelper;
import org.javalite.common.Convert;
import org.javalite.test.jspec.TestException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Before;
import org.springframework.mock.web.MockHttpServletResponse;

public class RequestSpecHelper
extends SpecHelper {
    @Before
    public final void atStart00() {
        Configuration.setTesting((boolean)true);
    }

    protected int statusCode() {
        return RequestContext.getControllerResponse().getStatus();
    }

    protected String contentType() {
        return RequestContext.getControllerResponse().getContentType();
    }

    protected String responseContent() {
        try {
            return ((MockHttpServletResponse)RequestContext.getHttpResponse()).getContentAsString();
        }
        catch (SpecException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecException(e);
        }
    }

    protected byte[] bytesContent() {
        try {
            return ((MockHttpServletResponse)RequestContext.getHttpResponse()).getContentAsByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String layout() {
        ControllerResponse resp = RequestContext.getControllerResponse();
        try {
            if (!(resp instanceof RenderTemplateResponse)) {
                throw new SpecException("failed to get layout, did you perform a render operation? I found a different  response: " + resp.getClass());
            }
            return ((RenderTemplateResponse)resp).getLayout();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected String template() {
        ControllerResponse resp = RequestContext.getControllerResponse();
        try {
            if (!(resp instanceof RenderTemplateResponse)) {
                throw new SpecException("failed to get layout, did you perform a render operation? I found a different  response: " + resp.getClass());
            }
            return ((RenderTemplateResponse)resp).getTemplate();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    protected Map assigns() {
        if (RequestContext.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return RequestContext.getControllerResponse().values();
    }

    protected Map vals() {
        if (RequestContext.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return RequestContext.getControllerResponse().values();
    }

    protected Object val(String name) {
        if (RequestContext.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        Object val = RequestContext.getControllerResponse().values().get(name);
        return val == null ? RequestContext.getHttpRequest().getAttribute(name) : val;
    }

    protected <T> T val(String name, Class<T> type) {
        if (RequestContext.getControllerResponse() == null) {
            throw new TestException("There is no controller response, did you actually invoke a controller/action?");
        }
        return (T)RequestContext.getControllerResponse().values().get(name);
    }

    protected String header(String headerName) {
        return RequestContext.getHttpResponse().getHeader(headerName);
    }

    protected Map<String, String> headers() {
        Collection headerNames = RequestContext.getHttpResponse().getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : headerNames) {
            headers.put(name, this.header(name));
        }
        return headers;
    }

    protected List<String> headerNames() {
        return new ArrayList<String>(RequestContext.getHttpResponse().getHeaderNames());
    }

    protected String valString(String name) {
        assert (name != null);
        return this.val(name).toString();
    }

    protected int valInteger(String name) {
        assert (name != null);
        return Convert.toInteger((Object)this.val(name));
    }

    protected long valLong(String name) {
        assert (name != null);
        return Convert.toLong((Object)this.val(name));
    }

    protected double valDouble(String name) {
        assert (name != null);
        return Convert.toDouble((Object)this.val(name));
    }

    protected float valFloat(String name) {
        assert (name != null);
        return Convert.toFloat((Object)this.val(name)).floatValue();
    }

    protected boolean valBoolean(String name) {
        assert (name != null);
        return Convert.toBoolean((Object)this.val(name));
    }

    protected boolean redirected() {
        return RequestContext.getControllerResponse() instanceof RedirectResponse;
    }

    protected String redirectValue() {
        ControllerResponse resp = RequestContext.getControllerResponse();
        if (resp != null && resp instanceof RedirectResponse) {
            RedirectResponse redirectResponse = (RedirectResponse)resp;
            return redirectResponse.redirectValue();
        }
        return null;
    }

    protected Cookie[] getCookies() {
        if (RequestContext.getHttpResponse() == null) {
            throw new IllegalStateException("response does not exist");
        }
        javax.servlet.http.Cookie[] servletCookies = ((MockHttpServletResponse)RequestContext.getHttpResponse()).getCookies();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (javax.servlet.http.Cookie cookie : servletCookies) {
            cookies.add(Cookie.fromServletCookie((javax.servlet.http.Cookie)cookie));
        }
        return cookies.toArray(new Cookie[0]);
    }

    protected Cookie cookie(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = this.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    protected String cookieValue(String name) {
        return this.cookie(name).getValue();
    }

    protected String text(String cssQuery) {
        Document doc = Jsoup.parse((String)this.responseContent().replace("'", "\""));
        Elements elements = doc.select(cssQuery);
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() > 1) {
            throw new IllegalArgumentException("Your query points to multiple elements. Choose only one.");
        }
        return ((Element)elements.get(0)).text();
    }

    public int count(String cssQuery) {
        return Jsoup.parse((String)this.responseContent().replace("'", "\"")).select(cssQuery).size();
    }
}

