/*
Copyright 2009-2016 Igor Polevoy

Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 

http://www.apache.org/licenses/LICENSE-2.0 

Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
*/

package org.javalite.activeweb;


import org.javalite.test.jspec.JSpecSupport;
import org.junit.*;
import org.junit.jupiter.api.*;

/**
 * Super class of a general spec that requires a connection to a test DB.
 * Before each test, a connection is opened to a test DB and transaction is started.
 * After each test, a connection is closed and a transaction is rolled back.
 *
 *
 * @deprecated do not use
 *
 * @author Igor Polevoy
 */
public class DBSpec implements JSpecSupport {

    @BeforeClass @BeforeAll
    public static void initDBConfig() {
        DBSpecHelper.initDBConfig();
    }    

    @Before @BeforeEach
    public final void open(){
        DBSpecHelper.openTestConnections();
    }

    @After @AfterEach
    public final void after(){
        DBSpecHelper.closeTestConnections();
    }

    @AfterClass @AfterAll
    public static void tearDown() {
        DBSpecHelper.clearConnectionWrappers();
    }
    
}
