/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.RequestBuilder;
import org.javalite.activeweb.RequestSpecHelper;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.SpecException;
import org.javalite.common.Util;
import org.junit.jupiter.api.BeforeEach;

public class ControllerSpec
extends RequestSpecHelper {
    private String controllerPath;

    public ControllerSpec() {
        Configuration.resetFilters();
        Configuration.setInjector(null);
    }

    @Override
    @BeforeEach
    public void atStart() {
        super.atStart();
        this.controllerPath = this.getControllerPath();
    }

    protected RequestBuilder request() {
        return new RequestBuilder(this.controllerPath, this.session());
    }

    protected RequestBuilder request(boolean integrateViews) {
        return new RequestBuilder(this.controllerPath, this.session());
    }

    protected final String getControllerPath() {
        Class<?> controllerClass;
        String controllerClassName = this.getControllerClassName();
        try {
            controllerClass = Class.forName(controllerClassName);
        }
        catch (Exception e) {
            throw new SpecException("Failed to find a class for: " + controllerClassName, e);
        }
        return Router.getControllerPath(controllerClass);
    }

    protected final String getControllerClassName() {
        String packageName = this.getClass().getPackage().getName();
        if (!packageName.startsWith("app.controllers")) {
            throw new SpecException("controller specs must be located in package 'app.controllers' or sub-packages");
        }
        if (!this.getClass().getSimpleName().endsWith("ControllerSpec")) {
            throw new SpecException("Descendant of activeweb.ControllerSpec must be named with: controller name + 'Spec', and because controllers have to have a suffix 'Controller', controller spec classes  must have a suffix: 'ControllerSpec' ");
        }
        String temp = this.getClass().getName();
        temp = (temp = temp.substring(16)).contains(".") ? temp.substring(0, temp.lastIndexOf(".")) : "";
        String specClassName = this.getClass().getSimpleName();
        String controllerName = specClassName.substring(0, specClassName.lastIndexOf("Spec"));
        return "app.controllers." + (Util.blank((Object)temp) ? "" : temp + ".") + controllerName;
    }
}

