/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.LinkedList;
import java.util.List;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.connection_config.ConnectionConfig;
import org.javalite.activejdbc.connection_config.DBConfiguration;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSpecHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(DBSpecHelper.class);

    private DBSpecHelper() {
    }

    public static void initDBConfig() {
        String dbConfigClassName = Configuration.get((String)"dbconfig");
        try {
            Object dbconfig = Class.forName(dbConfigClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dbconfig.getClass().getMethod("init", AppContext.class).invoke(dbconfig, new AppContext());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Failed to locate class: " + dbConfigClassName + ", proceeding without it...");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize class " + dbConfigClassName + " are you sure you defined this class?", e);
        }
    }

    public static void clearConnectionConfigs() {
        DBConfiguration.clearConnectionConfigs();
    }

    public static void openTestConnections() {
        List<ConnectionConfig> connectionConfigs = DBSpecHelper.getTestConnectionConfigs();
        if (connectionConfigs.isEmpty()) {
            LOGGER.warn("no DB connections are configured, none opened");
            return;
        }
        for (ConnectionConfig connectionConfig : connectionConfigs) {
            DB db = new DB(connectionConfig.getDbName());
            db.open(connectionConfig);
            if (!Configuration.rollback()) continue;
            db.openTransaction();
        }
    }

    public static void closeTestConnections() {
        List<ConnectionConfig> connectionConfigs = DBSpecHelper.getTestConnectionConfigs();
        for (ConnectionConfig connectionConfig : connectionConfigs) {
            String dbName = connectionConfig.getDbName();
            DB db = new DB(dbName);
            if (Configuration.rollback()) {
                db.rollbackTransaction();
            }
            db.close();
        }
    }

    private static List<ConnectionConfig> getTestConnectionConfigs() {
        List allConnections = DBConfiguration.getConnectionConfigsForCurrentEnv();
        LinkedList<ConnectionConfig> result = new LinkedList<ConnectionConfig>();
        for (ConnectionConfig connectionConfig : allConnections) {
            if (!connectionConfig.isTesting()) continue;
            result.add(connectionConfig);
        }
        return result;
    }
}

