/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.javalite.activejdbc.connection_config.DBConfiguration;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.DBSpecHelper;
import org.javalite.activeweb.IntegrationSpec;
import org.javalite.activeweb.RequestBuilder;
import org.javalite.activeweb.RequestDispatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.mock.web.MockFilterConfig;

public abstract class AppIntegrationSpec
extends IntegrationSpec {
    private boolean suppressDb;
    private AppContext context;
    private RequestDispatcher requestDispatcher = new RequestDispatcher();
    private boolean rollback = true;

    public boolean rollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
        DBSpecHelper.setRollback(rollback);
    }

    @BeforeClass
    @BeforeAll
    public static void initDBConfig() {
        DBSpecHelper.initDBConfig();
    }

    @Before
    @BeforeEach
    public void beforeAppIntegrationSpec() throws ServletException {
        this.requestDispatcher.init((FilterConfig)new MockFilterConfig());
        this.context = this.requestDispatcher.getContext();
        if (!this.suppressDb) {
            DBConfiguration.openTestConnections((boolean)this.rollback);
        }
    }

    @After
    @AfterEach
    public void closeTestConnections() {
        if (!this.suppressDb) {
            DBConfiguration.closeTestConnections((boolean)this.rollback);
        }
        this.requestDispatcher.destroy();
    }

    @AfterClass
    @AfterAll
    public static void clearConnectionConfigs() {
        DBConfiguration.clearConnectionConfigs();
    }

    public AppContext getContext() {
        return this.context;
    }

    @Override
    protected RequestBuilder controller(String controllerPath) {
        return new RequestBuilder(controllerPath);
    }

    protected void suppressDb() {
        this.suppressDb = true;
    }
}

