/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.InitException;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSpecHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(DBSpecHelper.class);

    private DBSpecHelper() {
    }

    public static void initDBConfig() {
        String dbConfigClassName = Configuration.get((String)"dbconfig");
        try {
            Object dbconfig = Class.forName(dbConfigClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dbconfig.getClass().getMethod("init", AppContext.class).invoke(dbconfig, new AppContext());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Failed to locate class: " + dbConfigClassName + ", proceeding without it...");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to initialize class " + dbConfigClassName + " are you sure you defined this class?", e);
        }
    }

    public static void setRollback(boolean rollback) {
        Map connections = DB.connections();
        for (String name : connections.keySet()) {
            try {
                boolean autocommit = !rollback;
                ((Connection)connections.get(name)).setAutoCommit(autocommit);
            }
            catch (SQLException e) {
                throw new InitException((Throwable)e);
            }
        }
    }
}

