/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javalite.activeweb.AWMockMultipartHttpServletRequest;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.ControllerRunner;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.FormItem;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.MockMultipartHttpServletRequestImpl;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.SpecException;
import org.javalite.common.Collections;
import org.javalite.test.jspec.JSpec;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RequestBuilder {
    private static final String MULTIPART = "multipart/form-data";
    private Map<String, List> values = new HashMap<String, List>();
    private Map<String, String> headers = new HashMap<String, String>();
    private String contentType;
    private byte[] content;
    private String controllerPath;
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private MockHttpServletRequest request;
    private String realAction;
    private List<FormItem> formItems = new ArrayList<FormItem>();
    private String id;
    private String queryString;
    private String format;
    private String remoteAddress;

    public RequestBuilder(String controllerPath) {
        RequestContext.setControllerResponse(null);
        RequestContext.setParams1st(null);
        RequestContext.setControllerResponse(null);
        RequestContext.setEncoding(null);
        RequestContext.setFormat(null);
        RequestContext.setFormItems(null);
        RequestContext.setHttpResponse(null);
        this.controllerPath = controllerPath;
    }

    public RequestBuilder formItem(Object fieldName, Object value) {
        JSpec.a((Object)fieldName).shouldNotBeNull();
        JSpec.a((Object)value).shouldNotBeNull();
        return this.formItem(fieldName.toString(), fieldName.toString(), false, "text/plain", value.toString().getBytes());
    }

    public RequestBuilder formItems(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            JSpec.a((Object)namesAndValues[i]).shouldNotBeNull();
            JSpec.a((Object)namesAndValues[i + 1]).shouldNotBeNull();
            this.formItem(namesAndValues[i].toString(), namesAndValues[i].toString(), false, "text/plain", namesAndValues[i + 1].toString().getBytes());
        }
        return this;
    }

    public RequestBuilder formItem(String fileName, String fieldName, boolean isFile, String contentType, byte[] content) {
        this.checkContentType();
        this.formItems.add(new FormItem(fileName, fieldName, isFile, contentType, content));
        return this;
    }

    public RequestBuilder formItem(FormItem item) {
        this.checkContentType();
        this.formItems.add(item);
        return this;
    }

    private void checkContentType() {
        if (this.contentType == null || !this.contentType.equals(MULTIPART)) {
            throw new IllegalArgumentException("Must set content type to: 'multipart/form-data' before adding a new form item");
        }
    }

    private void checkParamAndMultipart() {
        if (this.contentType != null && this.contentType.equals(MULTIPART) && this.values.size() > 0) {
            throw new IllegalArgumentException("cannot use param() with content type: multipart/form-data, use formItem()");
        }
    }

    public RequestBuilder param(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("neither argument can be null");
        }
        if (value instanceof List) {
            List list = (List)value;
            this.values.put(name, list);
        } else {
            this.values.put(name, Collections.list((Object[])new Object[]{value}));
        }
        return this;
    }

    public RequestBuilder param(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        this.values.put(name, Collections.list((Object[])new String[]{""}));
        return this;
    }

    public RequestBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder headers(String ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null || namesAndValues[i + 1] == null) {
                throw new IllegalArgumentException("header names or values cannot be null");
            }
            this.header(namesAndValues[i], namesAndValues[i + 1]);
        }
        return this;
    }

    public RequestBuilder params(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("parameter names cannot be nulls");
            }
            this.param(namesAndValues[i].toString(), namesAndValues[i + 1]);
        }
        return this;
    }

    public RequestBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RequestBuilder cookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public RequestBuilder content(String content) {
        return this.content(content.getBytes());
    }

    public RequestBuilder json(String content) {
        this.contentType("application/json");
        return this.content(content.getBytes());
    }

    public RequestBuilder content(byte[] content) {
        this.content = content;
        return this;
    }

    public void get(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.GET);
    }

    public void post(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.POST);
    }

    public void put(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.PUT);
    }

    public void delete(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.DELETE);
    }

    public void options(String actionName) {
        this.realAction = actionName;
        this.submitRequest(actionName, HttpMethod.OPTIONS);
    }

    private void submitRequest(String actionName, HttpMethod method) throws RuntimeException {
        this.checkParamAndMultipart();
        this.createAndConfigureRequest(method);
        try {
            AppController controller = ControllerFactory.createControllerInstance((String)ControllerFactory.getControllerClassName((String)this.controllerPath));
            RequestContext.setRoute((Route)new Route(controller, this.realAction, this.id, method));
            Injector injector = Configuration.getInjector();
            if (injector != null) {
                injector.injectMembers((Object)controller);
            }
            ControllerRunner runner = new ControllerRunner();
            RequestContext.setControllerResponse(null);
            RequestContext.setHttpResponse((HttpServletResponse)new MockHttpServletResponse());
            runner.run(new Route(controller, actionName, method));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpecException(e);
        }
    }

    private void createAndConfigureRequest(HttpMethod method) {
        String path;
        HttpServletRequest prevRequest = RequestContext.getHttpRequest();
        if (this.contentType != null && this.contentType.equals(MULTIPART) && !this.formItems.isEmpty()) {
            this.request = new MockMultipartHttpServletRequestImpl();
            for (FormItem item : this.formItems) {
                ((AWMockMultipartHttpServletRequest)this.request).addFormItem(item);
            }
        } else {
            this.request = new MockHttpServletRequest();
        }
        this.request.setContextPath("/test_context");
        RequestContext.setHttpRequest((HttpServletRequest)this.request);
        RequestContext.setFormat((String)this.format);
        if (this.remoteAddress != null) {
            this.request.setRemoteAddr(this.remoteAddress);
        }
        if (prevRequest != null) {
            this.request.setSession(prevRequest.getSession(false));
        }
        if (this.contentType != null) {
            this.request.setContentType(this.contentType);
        }
        if (this.content != null) {
            this.request.setContent(this.content);
        }
        if (!(path = this.controllerPath + (String)(this.realAction != null ? "/" + this.realAction : "")).startsWith("/")) {
            path = "/" + path;
        }
        this.request.setServletPath(path);
        this.request.setRequestURI(path);
        this.request.setAttribute("id", (Object)this.id);
        this.request.setQueryString(this.queryString);
        this.addCookiesInternal(this.request);
        if (method.equals((Object)HttpMethod.PUT)) {
            this.request.setParameter("_method", method.toString());
            this.request.setMethod("POST");
        } else {
            this.request.setMethod(method.toString());
        }
        this.addHeaders(this.request);
        this.addParameterValues(this.values, this.request);
        this.addParameterValuesFromQueryString(this.request);
    }

    private void addHeaders(MockHttpServletRequest request) {
        for (String header : this.headers.keySet()) {
            request.addHeader(header, (Object)this.headers.get(header));
        }
    }

    private void addCookiesInternal(MockHttpServletRequest request) {
        ArrayList<javax.servlet.http.Cookie> servletCookieList = new ArrayList<javax.servlet.http.Cookie>();
        for (Cookie cookie : this.cookies) {
            servletCookieList.add(Cookie.toServletCookie((Cookie)cookie));
        }
        javax.servlet.http.Cookie[] arr = servletCookieList.toArray(new javax.servlet.http.Cookie[0]);
        request.setCookies(arr);
    }

    private void addParameterValues(Map<String, List> valuesMap, MockHttpServletRequest httpServletRequest) {
        for (String key : valuesMap.keySet()) {
            List value = valuesMap.get(key);
            ArrayList<String> strings = new ArrayList<String>(value.size());
            for (Object v : value) {
                strings.add(v == null ? "" : v.toString());
            }
            httpServletRequest.addParameter(key, strings.toArray(new String[0]));
        }
    }

    private void addParameterValuesFromQueryString(MockHttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString != null) {
            Map<String, List> params = this.splitQuery(queryString);
            this.addParameterValues(params, request);
        }
    }

    private Map<String, List> splitQuery(String uri) {
        String[] pairs;
        LinkedHashMap<String, List> query_pairs = new LinkedHashMap<String, List>();
        for (String pair : pairs = uri.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8) : null;
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }

    public RequestBuilder id(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null");
        }
        this.id = id.toString();
        return this;
    }

    public RequestBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format can't be null");
        }
        this.format = format;
        return this;
    }

    public RequestBuilder queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public RequestBuilder remoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }
}

