/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ParamCopy;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.RequestVo;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.SpecHelper;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.freemarker.ContentTL;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.FreeMarkerTemplateManager;
import org.javalite.common.Collections;
import org.junit.After;
import org.junit.Before;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class ViewSpec
extends SpecHelper {
    private FreeMarkerTemplateManager manager = new FreeMarkerTemplateManager();

    public ViewSpec() {
        this.manager.setTemplateLocation("src/main/webapp/WEB-INF/views");
    }

    @Before
    public final void beforeTest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/test_context");
        RequestContext.setTLs((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse(), (FilterConfig)new MockFilterConfig(), (AppContext)new AppContext(), (RequestVo)new RequestVo(), null);
    }

    @After
    public final void afterTest() {
        RequestContext.clear();
    }

    @Override
    public void setTemplateLocation(String templateLocation) {
        this.manager.setTemplateLocation(templateLocation);
    }

    @Override
    protected void setInjector(Injector injector) {
        Configuration.setInjector((Injector)injector);
    }

    @Override
    protected void registerTag(String name, FreeMarkerTag tag) {
        this.manager.registerTag(name, tag);
        Injector injector = Configuration.getInjector();
        if (injector != null) {
            injector.injectMembers((Object)tag);
        }
    }

    protected String render(String templateName) {
        return this.render(templateName, new HashMap());
    }

    protected String render(String templateName, Map values) {
        StringWriter stringWriter = new StringWriter();
        ParamCopy.copyInto((Map)values);
        this.manager.merge(values, templateName, (Writer)stringWriter, false);
        return stringWriter.toString();
    }

    protected String render(String templateName, String ... namesAndValues) {
        return this.render(templateName, Collections.map((Object[])namesAndValues));
    }

    protected <T extends AppController> void setCurrentController(Class<T> controllerClass) {
        try {
            AppController instance = (AppController)controllerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RequestContext.setRoute((Route)new Route(instance));
        }
        catch (Exception e) {
            throw new ViewException((Throwable)e);
        }
    }

    protected List<String> contentFor(String name) {
        return (List)ContentTL.getAllContent().get(name);
    }
}

