/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javalite.activeweb.AppConfig;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.controller_filters.ControllerFilter;

public abstract class AbstractControllerConfig
extends AppConfig {
    private List<ExcludeBuilder> excludeBuilders = new ArrayList<ExcludeBuilder>();

    protected FilterBuilder add(ControllerFilter ... filters) {
        return new FilterBuilder(filters);
    }

    protected ExcludeBuilder addGlobalFilters(ControllerFilter ... filters) {
        ExcludeBuilder excludeBuilder = new ExcludeBuilder(filters);
        this.excludeBuilders.add(excludeBuilder);
        return excludeBuilder;
    }

    @Override
    public void completeInit() {
        for (ExcludeBuilder excludeBuilder : this.excludeBuilders) {
            Context.getControllerRegistry().addGlobalFilters(excludeBuilder.getFilters(), excludeBuilder.getExcludeControllerClasses());
        }
    }

    public class ExcludeBuilder {
        private List<Class<? extends AppController>> excludeControllerClasses = new ArrayList<Class<? extends AppController>>();
        private List<ControllerFilter> filters = new ArrayList<ControllerFilter>();

        public ExcludeBuilder(ControllerFilter[] filters) {
            this.filters.addAll(Arrays.asList(filters));
        }

        public void exceptFor(Class<? extends AppController> ... excludeControllerClasses) {
            this.excludeControllerClasses.addAll(Arrays.asList(excludeControllerClasses));
        }

        public List<Class<? extends AppController>> getExcludeControllerClasses() {
            return this.excludeControllerClasses;
        }

        public List<ControllerFilter> getFilters() {
            return this.filters;
        }
    }

    public class FilterBuilder {
        private ControllerFilter[] filters;
        private Class<? extends AppController>[] controllerClasses;

        protected FilterBuilder(ControllerFilter[] filters) {
            this.filters = filters;
        }

        public FilterBuilder to(Class<? extends AppController> ... controllerClasses) {
            this.controllerClasses = controllerClasses;
            for (Class<? extends AppController> controllerClass : controllerClasses) {
                Context.getControllerRegistry().getMetaData(controllerClass).addFilters(this.filters);
            }
            return this;
        }

        public void forActions(String ... actionNames) {
            if (this.controllerClasses == null) {
                throw new IllegalArgumentException("controller classes not provided. Please call 'to(controllers)' before 'forActions(actions)'");
            }
            for (Class<? extends AppController> controllerClass : this.controllerClasses) {
                Context.getControllerRegistry().getMetaData(controllerClass).addFilters(this.filters, actionNames);
            }
        }

        public void excludeActions(String ... excludedActions) {
            if (this.controllerClasses == null) {
                throw new IllegalArgumentException("controller classes not provided. Please call 'to(controllers)' before 'exceptAction(actions)'");
            }
            for (Class<? extends AppController> controllerClass : this.controllerClasses) {
                Context.getControllerRegistry().getMetaData(controllerClass).addFiltersWithExcludedActions(this.filters, excludedActions);
            }
        }
    }
}

