/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activeweb.AppConfig;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ConfigurationException;
import org.javalite.activeweb.ConnectionBuilder;
import org.javalite.activeweb.InitException;

public abstract class AbstractDBConfig
extends AppConfig {
    public ConnectionBuilder environment(String environment) {
        return new ConnectionBuilder(environment);
    }

    public ConnectionBuilder environment(String environment, boolean override) {
        return new ConnectionBuilder(environment, override);
    }

    public void configFile(String file) {
        try {
            Properties props = this.readPropertyFile(file);
            Set<String> environments = this.getEnvironments(props);
            for (String env : environments) {
                String jndiName = env + "." + "jndi";
                if (props.containsKey(jndiName)) {
                    this.createJndiWrapper(env, props.getProperty(jndiName));
                    continue;
                }
                String driver = props.getProperty(env + ".driver");
                String userName = props.getProperty(env + ".username");
                String password = props.getProperty(env + ".password");
                String url = props.getProperty(env + ".url");
                this.checkProps(driver, userName, password, url, env);
                this.createJdbcWrapper(env, driver, url, userName, password);
            }
        }
        catch (InitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    private void checkProps(String driver, String userName, String password, String url, String env) {
        if (driver == null || userName == null || password == null || url == null) {
            throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
        }
    }

    private void createJdbcWrapper(String env, String driver, String url, String userName, String password) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        if (env.equals("test")) {
            wrapper.setEnvironment("development");
            wrapper.setTesting(true);
        } else if (env.endsWith(".test")) {
            wrapper.setEnvironment(env.split("\\.")[0]);
            wrapper.setTesting(true);
        } else {
            wrapper.setEnvironment(env);
        }
        ConnectionJdbcSpec connectionSpec = new ConnectionJdbcSpec(driver, url, userName, password);
        wrapper.setConnectionSpec((ConnectionSpec)connectionSpec);
        Configuration.addConnectionWrapper(wrapper, false);
    }

    private void createJndiWrapper(String env, String jndiName) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        wrapper.setEnvironment(env);
        ConnectionJndiSpec connectionSpec = new ConnectionJndiSpec(jndiName);
        wrapper.setConnectionSpec((ConnectionSpec)connectionSpec);
        Configuration.addConnectionWrapper(wrapper, false);
    }

    private Set<String> getEnvironments(Properties props) {
        HashSet<String> environments = new HashSet<String>();
        for (String prop : props.stringPropertyNames()) {
            String[] parts = prop.split("\\.");
            if (parts.length == 2) {
                environments.add(parts[0]);
                continue;
            }
            if (parts.length == 3 && parts[1].equals("test")) {
                environments.add(parts[0] + ".test");
                continue;
            }
            throw new ConfigurationException("Incorrect property: " + prop);
        }
        return environments;
    }

    private Properties readPropertyFile(String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        Properties props = new Properties();
        if (in != null) {
            props.load(in);
        } else {
            FileInputStream fin = new FileInputStream(file);
            props.load(fin);
            fin.close();
        }
        return props;
    }
}

