/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemStream;

class ApacheFileItemFacade
implements FileItemStream {
    private String name;
    private String fieldName;
    private String contentType;
    private boolean isFile;
    private byte[] content;
    private InputStream inputStream;

    ApacheFileItemFacade(String name, String fieldName, String contentType, boolean isFile, byte[] content) {
        this.name = name;
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFile = isFile;
        this.content = content;
    }

    ApacheFileItemFacade(FileItem apacheFileItem) throws IOException {
        this.name = apacheFileItem.getName();
        this.fieldName = apacheFileItem.getFieldName();
        this.contentType = apacheFileItem.getContentType();
        this.isFile = !apacheFileItem.isFormField();
        this.inputStream = apacheFileItem.getInputStream();
    }

    public InputStream openStream() throws IOException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        throw new RuntimeException("this should never happen :(");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isFormField() {
        return !this.isFile;
    }

    public FileItemHeaders getHeaders() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setHeaders(FileItemHeaders fileItemHeaders) {
        throw new UnsupportedOperationException("not implemented");
    }
}

