/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javalite.activeweb.ActionNotFoundException;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.HttpSupport;
import org.javalite.activeweb.KeyWords;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.annotations.RESTful;

public abstract class AppController
extends HttpSupport {
    @Override
    protected void assign(String name, Object value) {
        KeyWords.check(name);
        Context.getValues().put(name, value);
    }

    @Override
    protected void view(String name, Object value) {
        this.assign(name, value);
    }

    protected Map values() {
        return Context.getValues();
    }

    protected HttpSupport.RenderBuilder render(String template) {
        String targetTemplate = template.startsWith("/") ? template : Router.getControllerPath(this.getClass()) + "/" + template;
        return this.render(targetTemplate, this.values());
    }

    protected HttpSupport.RenderBuilder render() {
        String template = Router.getControllerPath(this.getClass()) + "/" + Context.getRoute().getActionName();
        return super.render(template, this.values());
    }

    protected String servletPath() {
        return Context.getHttpRequest().getServletPath();
    }

    @Override
    protected String queryString() {
        return Context.getHttpRequest().getQueryString();
    }

    protected String getLayout() {
        return Configuration.getDefaultLayout();
    }

    protected String getContentType() {
        return "text/html";
    }

    public boolean actionSupportsHttpMethod(String actionMethodName, HttpMethod httpMethod) {
        if (this.restful()) {
            return this.restfulActionSupportsHttpMethod(actionMethodName, httpMethod) || this.standardActionSupportsHttpMethod(actionMethodName, httpMethod);
        }
        return this.standardActionSupportsHttpMethod(actionMethodName, httpMethod);
    }

    protected boolean standardActionSupportsHttpMethod(String actionMethodName, HttpMethod httpMethod) {
        for (HttpMethod m : this.allowedActions(actionMethodName)) {
            if (m != httpMethod) continue;
            return true;
        }
        return false;
    }

    protected List<HttpMethod> allowedActions(String actionMethodName) {
        try {
            Method method = this.getClass().getMethod(actionMethodName, new Class[0]);
            Annotation[] annotations = method.getAnnotations();
            if (annotations.length == 0) {
                return Collections.singletonList(HttpMethod.GET);
            }
            ArrayList<HttpMethod> res = new ArrayList<HttpMethod>();
            for (Annotation annotation : annotations) {
                try {
                    res.add(HttpMethod.valueOf(annotation.annotationType().getSimpleName()));
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
            }
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new ActionNotFoundException(e);
        }
    }

    private boolean restfulActionSupportsHttpMethod(String action, HttpMethod httpMethod) {
        if (action.equals("index") && httpMethod.equals((Object)HttpMethod.GET)) {
            return true;
        }
        if (action.equals("newForm") && httpMethod.equals((Object)HttpMethod.GET)) {
            return true;
        }
        if (action.equals("create") && httpMethod.equals((Object)HttpMethod.POST)) {
            return true;
        }
        if (action.equals("show") && httpMethod.equals((Object)HttpMethod.GET)) {
            return true;
        }
        if (action.equals("editForm") && httpMethod.equals((Object)HttpMethod.GET)) {
            return true;
        }
        if (action.equals("update") && httpMethod.equals((Object)HttpMethod.PUT)) {
            return true;
        }
        if (action.equals("destroy") && httpMethod.equals((Object)HttpMethod.DELETE)) {
            return true;
        }
        if (action.equals("options") && httpMethod.equals((Object)HttpMethod.OPTIONS)) {
            return true;
        }
        this.logDebug("You might want to execute a non-restful action on a restful controller. It is recommended that you use the following methods on restful controllers: index, newForm, create, show, editForm, update, destroy");
        return false;
    }

    public boolean restful() {
        return this.getClass().getAnnotation(RESTful.class) != null;
    }

    public static <T extends AppController> boolean restful(Class<T> controllerClass) {
        return controllerClass.getAnnotation(RESTful.class) != null;
    }
}

