/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.imageio.ImageIO;

public class Captcha {
    private Captcha() {
    }

    public static String generateText() {
        return new StringTokenizer(UUID.randomUUID().toString(), "-").nextToken();
    }

    public static byte[] generateImage(String text) {
        int i;
        int w = 180;
        int h = 40;
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        g.setFont(new Font("Serif", 0, 26));
        g.setColor(Color.blue);
        int start = 10;
        byte[] bytes = text.getBytes();
        Random random = new Random();
        for (i = 0; i < bytes.length; ++i) {
            g.setColor(new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255)));
            g.drawString(new String(new byte[]{bytes[i]}), start + i * 20, (int)(Math.random() * 20.0 + 20.0));
        }
        g.setColor(Color.white);
        for (i = 0; i < 8; ++i) {
            g.drawOval((int)(Math.random() * 160.0), (int)(Math.random() * 10.0), 30, 30);
        }
        g.dispose();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", bout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bout.toByteArray();
    }
}

