/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activeweb.InitException;
import org.javalite.activeweb.TemplateManager;
import org.javalite.activeweb.freemarker.AbstractFreeMarkerConfig;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Configuration.class.getSimpleName());
    private static Properties props = new Properties();
    private static TemplateManager templateManager;
    private static HashMap<String, List<ConnectionSpecWrapper>> connectionWrappers;
    private static boolean testing;
    private static String ENV;
    private static boolean activeReload;
    private static AbstractFreeMarkerConfig freeMarkerConfig;
    private static boolean useDefaultLayoutForErrors;

    public static void setUseDefaultLayoutForErrors(boolean useDefaultLayoutForErrors) {
        Configuration.useDefaultLayoutForErrors = useDefaultLayoutForErrors;
    }

    protected static boolean useDefaultLayoutForErrors() {
        return useDefaultLayoutForErrors;
    }

    public static boolean logRequestParams() {
        String logRequest = System.getProperty("activeweb.log.request");
        return logRequest != null && logRequest.equals("true");
    }

    public static boolean runningIn(String environment) {
        return Configuration.getEnv().equals(environment);
    }

    public static String getEnv() {
        if (ENV == null) {
            if (!Util.blank((Object)System.getenv("ACTIVE_ENV"))) {
                ENV = System.getenv("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("ACTIVE_ENV"))) {
                ENV = System.getProperty("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("active_env"))) {
                ENV = System.getProperty("active_env");
            }
            if (Util.blank((Object)ENV)) {
                ENV = "development";
                LOGGER.warn("Environment variable ACTIVE_ENV not provided, defaulting to '" + ENV + "'");
            }
        }
        return ENV;
    }

    protected static void setEnv(String env) {
        ENV = env;
    }

    public static boolean isTesting() {
        return testing;
    }

    protected static void setTesting(boolean testing) {
        Configuration.testing = testing;
    }

    private static void checkInitProperties() {
        for (Params param : Params.values()) {
            if (props.get(param.toString()) != null) continue;
            throw new InitException("Must provide property: " + (Object)((Object)param));
        }
    }

    private static void initTemplateManager() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            templateManager = (TemplateManager)Class.forName(Configuration.get(Params.templateManager.toString())).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    public static synchronized AbstractFreeMarkerConfig getFreeMarkerConfig() {
        if (freeMarkerConfig != null) {
            return freeMarkerConfig;
        }
        try {
            String className = Configuration.get(Params.freeMarkerConfig.toString());
            freeMarkerConfig = (AbstractFreeMarkerConfig)Class.forName(className).newInstance();
            return freeMarkerConfig;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to find implementation of '" + AbstractFreeMarkerConfig.class + "', proceeding without custom configuration of FreeMarker");
            return null;
        }
    }

    public static TemplateManager getTemplateManager() {
        return templateManager;
    }

    public static String get(String name) {
        return props.getProperty(name);
    }

    public static String getDefaultLayout() {
        return Configuration.get(Params.defaultLayout.toString());
    }

    public static String getBootstrapClassName() {
        return Configuration.get(Params.bootstrap.toString());
    }

    public static String getControllerConfigClassName() {
        return Configuration.get(Params.controllerConfig.toString());
    }

    public static String getDbConfigClassName() {
        return Configuration.get(Params.dbconfig.toString());
    }

    public static String getRouteConfigClassName() {
        return Configuration.get(Params.route_config.toString());
    }

    public static String getTargetDir() {
        return Configuration.get(Params.targetDir.toString());
    }

    public static String getRootPackage() {
        return Configuration.get(Params.rootPackage.toString());
    }

    public static boolean rollback() {
        return Boolean.parseBoolean(Configuration.get(Params.rollback.toString().trim()));
    }

    protected static void addConnectionWrapper(ConnectionSpecWrapper connectionWrapper, boolean override) {
        String connectionWrapperEnv = connectionWrapper.getEnvironment();
        List<ConnectionSpecWrapper> envConnectionWrappers = connectionWrappers.get(connectionWrapperEnv);
        if (envConnectionWrappers == null || override) {
            envConnectionWrappers = new ArrayList<ConnectionSpecWrapper>();
            connectionWrappers.put(connectionWrapperEnv, envConnectionWrappers);
        }
        envConnectionWrappers.add(connectionWrapper);
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers() {
        return Configuration.getConnectionSpecWrappers(Configuration.getEnv());
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers(String env) {
        return connectionWrappers.get(env) == null ? new ArrayList() : connectionWrappers.get(env);
    }

    protected static void clearConnectionWrappers() {
        Configuration.clearConnectionWrappers(Configuration.getEnv());
    }

    protected static void resetConnectionWrappers() {
        connectionWrappers = new HashMap();
    }

    protected static void clearConnectionWrappers(String env) {
        if (connectionWrappers.get(env) != null) {
            connectionWrappers.get(env).clear();
        }
    }

    public static boolean activeReload() {
        return activeReload;
    }

    public static int getMaxUploadSize() {
        return Integer.parseInt(Configuration.get(Params.maxUploadSize.toString()));
    }

    public static File getTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    static {
        connectionWrappers = new HashMap();
        activeReload = !Util.blank((Object)System.getProperty("active_reload")) && System.getProperty("active_reload").equals("true");
        useDefaultLayoutForErrors = true;
        try {
            props = new Properties();
            InputStream in1 = Configuration.class.getClassLoader().getResourceAsStream("activeweb_defaults.properties");
            props.load(in1);
            Properties overrides = new Properties();
            InputStream in2 = Configuration.class.getResourceAsStream("/activeweb.properties");
            if (in2 != null) {
                overrides.load(in2);
            }
            for (Object name : overrides.keySet()) {
                props.put(name, overrides.get(name));
            }
            Configuration.checkInitProperties();
            Configuration.initTemplateManager();
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    static enum Params {
        templateManager,
        bootstrap,
        defaultLayout,
        targetDir,
        rootPackage,
        dbconfig,
        controllerConfig,
        rollback,
        freeMarkerConfig,
        route_config,
        maxUploadSize;

    }
}

