/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.Properties;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activeweb.Configuration;

public class ConnectionBuilder {
    private ConnectionSpecWrapper connectionWrapper = new ConnectionSpecWrapper();

    ConnectionBuilder(String environment) {
        this.connectionWrapper.setEnvironment(environment);
        Configuration.addConnectionWrapper(this.connectionWrapper, false);
    }

    ConnectionBuilder(String environment, boolean override) {
        this.connectionWrapper.setEnvironment(environment);
        Configuration.addConnectionWrapper(this.connectionWrapper, override);
    }

    public void jndi(String jndi) {
        this.connectionWrapper.setConnectionSpec((ConnectionSpec)new ConnectionJndiSpec(jndi));
    }

    public void jdbc(String driver, String url, String user, String password) {
        this.connectionWrapper.setConnectionSpec((ConnectionSpec)new ConnectionJdbcSpec(driver, url, user, password));
    }

    public void jdbc(String driver, String url, Properties props) {
        this.connectionWrapper.setConnectionSpec((ConnectionSpec)new ConnectionJdbcSpec(driver, url, props));
    }

    public ConnectionBuilder db(String dbName) {
        this.connectionWrapper.setDbName(dbName);
        return this;
    }

    public ConnectionBuilder testing() {
        this.connectionWrapper.setTesting(true);
        return this;
    }
}

