/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ClassLoadException;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.DynamicClassFactory;
import org.javalite.common.Inflector;

public class ControllerFactory {
    private ControllerFactory() {
    }

    protected static AppController createControllerInstance(String controllerClassName) throws ClassLoadException {
        return DynamicClassFactory.createInstance(controllerClassName, AppController.class);
    }

    static String getControllerClassName(String controllerName, String packageSuffix) {
        String name = controllerName.replace('-', '_');
        String temp = Configuration.getRootPackage() + ".controllers";
        if (packageSuffix != null) {
            temp = temp + "." + packageSuffix;
        }
        return temp + "." + Inflector.camelize((String)name) + "Controller";
    }

    public static String getControllerClassName(String controllerPath) {
        String controller;
        if (!controllerPath.startsWith("/") && controllerPath.contains("/")) {
            throw new IllegalArgumentException("must start with '/'");
        }
        if (controllerPath.endsWith("/")) {
            throw new IllegalArgumentException("must not end with '/'");
        }
        String path = controllerPath.startsWith("/") ? controllerPath.substring(1) : controllerPath;
        String[] parts = path.split("/");
        String subPackage = null;
        if (parts.length == 0) {
            controller = path;
        } else if (parts.length == 1) {
            controller = parts[0];
        } else {
            subPackage = path.substring(0, path.lastIndexOf("/")).replace("/", ".");
            controller = path.substring(path.lastIndexOf("/") + 1);
        }
        String temp = Configuration.getRootPackage() + ".controllers";
        temp = temp + (subPackage != null ? "." + subPackage : "");
        temp = temp + "." + Inflector.camelize((String)controller.replace("-", "_"), (boolean)true) + "Controller";
        return temp;
    }
}

