/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.javalite.activeweb.controller_filters.ControllerFilter;

class ControllerMetaData {
    private List<ControllerFilter> controllerFilters = new LinkedList<ControllerFilter>();
    private HashMap<String, List<ControllerFilter>> actionFilterMap = new HashMap();
    private HashMap<String, List<ControllerFilter>> excludedActionFilterMap = new HashMap();

    ControllerMetaData() {
    }

    void addFilters(ControllerFilter[] filters) {
        Collections.addAll(this.controllerFilters, filters);
    }

    void addFilter(ControllerFilter filter) {
        this.controllerFilters.add(filter);
    }

    void addFiltersWithExcludedActions(ControllerFilter[] filters, String[] excludedActions) {
        for (String action : excludedActions) {
            this.excludedActionFilterMap.put(action, Arrays.asList(filters));
        }
    }

    void addFilters(ControllerFilter[] filters, String[] actionNames) {
        this.controllerFilters.removeAll(Arrays.asList(filters));
        for (String action : actionNames) {
            this.actionFilterMap.put(action, Arrays.asList(filters));
        }
    }

    protected List<ControllerFilter> getFilters(String action) {
        List<ControllerFilter> excludedFilters;
        LinkedList<ControllerFilter> result = new LinkedList<ControllerFilter>();
        result.addAll(this.controllerFilters);
        List<ControllerFilter> actionFilters = this.actionFilterMap.get(action);
        if (actionFilters != null) {
            result.addAll(actionFilters);
        }
        if ((excludedFilters = this.excludedActionFilterMap.get(action)) != null) {
            for (ControllerFilter excludedFilter : excludedFilters) {
                result.remove(excludedFilter);
            }
        }
        return result;
    }

    protected List<ControllerFilter> getFilters() {
        LinkedList<ControllerFilter> allFilters = new LinkedList<ControllerFilter>();
        allFilters.addAll(this.controllerFilters);
        for (List<ControllerFilter> filters : this.actionFilterMap.values()) {
            allFilters.addAll(filters);
        }
        for (List<ControllerFilter> filters : this.excludedActionFilterMap.values()) {
            allFilters.addAll(filters);
        }
        return allFilters;
    }

    protected void injectFilters(Injector injector) {
        for (ControllerFilter controllerFilter : this.getFilters()) {
            injector.injectMembers((Object)controllerFilter);
        }
    }
}

