/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.FilterConfig;
import org.javalite.activeweb.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControllerPackageLocator {
    private static Logger LOGGER = LoggerFactory.getLogger((String)ControllerPackageLocator.class.getSimpleName());

    private ControllerPackageLocator() {
    }

    public static List<String> locateControllerPackages(FilterConfig config) {
        String controllerPath = System.getProperty("file.separator") + Configuration.getRootPackage() + System.getProperty("file.separator") + "controllers";
        ArrayList<String> controllerPackages = new ArrayList<String>();
        List<URL> urls = ControllerPackageLocator.getUrls(config);
        for (URL url : urls) {
            File f = new File(url.getFile());
            if (f.isDirectory()) {
                try {
                    ControllerPackageLocator.discoverInDirectory(f.getCanonicalPath() + controllerPath, controllerPackages, "");
                }
                catch (Exception ignore) {}
                continue;
            }
            ControllerPackageLocator.discoverInJar(f, controllerPackages);
        }
        return controllerPackages;
    }

    private static void discoverInDirectory(String directoryPath, List<String> controllerPackages, String parent) {
        try {
            File directory = new File(directoryPath);
            if (directory.exists()) {
                File[] files;
                for (File file : files = directory.listFiles()) {
                    if (!file.isDirectory()) continue;
                    controllerPackages.add(parent + (parent.equals("") ? "" : ".") + file.getName());
                    ControllerPackageLocator.discoverInDirectory(file.getCanonicalPath(), controllerPackages, parent + (parent.equals("") ? "" : ".") + file.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void discoverInJar(File file, List<String> controllerPackages) {
        String base = "app/controllers/";
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String path = jarEntry.toString();
                if (!path.startsWith(base) || path.endsWith(".class") || path.equals(base)) continue;
                controllerPackages.add(path.substring(base.length(), path.length() - 1).replace("/", "."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<URL> getUrls(FilterConfig config) {
        try {
            URL[] urls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
            return Arrays.asList(urls);
        }
        catch (ClassCastException e) {
            return ControllerPackageLocator.hackForWeblogic(config);
        }
    }

    private static List<URL> hackForWeblogic(FilterConfig config) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set libJars = config.getServletContext().getResourcePaths("/WEB-INF/lib");
        for (Object jar : libJars) {
            try {
                urls.add(config.getServletContext().getResource((String)jar));
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Failed to get resource: " + jar);
            }
        }
        ControllerPackageLocator.addClassesUrl(config, urls);
        return urls;
    }

    private static void addClassesUrl(FilterConfig config, List<URL> urls) {
        Set resources = config.getServletContext().getResourcePaths("/WEB-INF/classes/");
        System.out.println(resources);
        if (!resources.isEmpty()) {
            try {
                String first = resources.iterator().next().toString();
                String urlString = config.getServletContext().getResource(first).toString();
                String url = null;
                if (urlString.startsWith("zip") && urlString.contains("!")) {
                    url = urlString.substring(urlString.indexOf(":") + 2, urlString.indexOf("!"));
                } else if (urlString.startsWith("jndi")) {
                    url = urlString.substring(urlString.indexOf(":") + 2);
                }
                if (url != null) {
                    urls.add(new URL("file:/" + url));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

